/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapProvider;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonAdminService;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonServiceManager;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public class DaemonProvider
implements URCapProvider {
    private DaemonServiceManager daemonServiceManager;
    private DaemonAdminService daemonAdminService;
    private FrameworkAdapter frameworkAdapter;

    public DaemonProvider(DaemonAdminService daemonAdminService) {
        this.daemonAdminService = daemonAdminService;
    }

    @Inject
    public void setFrameworkAdapter(FrameworkAdapter frameworkAdapter) {
        this.frameworkAdapter = frameworkAdapter;
        this.daemonServiceManager = new DaemonServiceManager(this.daemonAdminService, frameworkAdapter);
    }

    public Collection<URCap> getURCaps() {
        this.frameworkAdapter.getBundle(this.getClass()).getBundleContext().addBundleListener((BundleListener)new StopDaemonWhenBundleStoppedListener());
        this.daemonServiceManager.removeUninstalledDaemons();
        this.daemonServiceManager.discoverInstalledDaemons();
        return Collections.EMPTY_LIST;
    }

    private class StopDaemonWhenBundleStoppedListener
    implements BundleListener {
        private StopDaemonWhenBundleStoppedListener() {
        }

        public void bundleChanged(BundleEvent bundleEvent) {
            if (bundleEvent.getType() == 4) {
                DaemonProvider.this.daemonServiceManager.stopAllDaemonsForBundle(bundleEvent.getBundle());
            }
        }
    }
}

