/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.polyscope.core.api.osgi.FrameworkAdapter;
import com.ur.polyscope.urcaps.internal.daemonservice.BundleResolver;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonAdminService;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonExtractionRegistration;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonImpl;
import com.ur.urcap.api.contribution.DaemonContribution;
import com.ur.urcap.api.contribution.DaemonService;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DaemonServiceManager {
    private final BundleContext bundleContext;
    private final DaemonAdminService daemonAdminService;
    private final List<DaemonImpl> daemons;
    private final DaemonExtractionRegistration extractionRegistration;

    public DaemonServiceManager(DaemonAdminService daemonAdminService, FrameworkAdapter frameworkAdapter) {
        this.bundleContext = frameworkAdapter.getBundle(DaemonServiceManager.class).getBundleContext();
        this.daemonAdminService = daemonAdminService;
        this.daemons = new ArrayList<DaemonImpl>();
        this.extractionRegistration = new DaemonExtractionRegistration(frameworkAdapter.getBundle(DaemonServiceManager.class).getDataFile("daemonExtractionRegistration.json"), new BundleResolver(frameworkAdapter));
    }

    public void removeUninstalledDaemons() {
        this.daemonAdminService.unregisterBrokenSymLinkDaemons();
    }

    public void discoverInstalledDaemons() {
        try {
            Collection daemonReferences = this.bundleContext.getServiceReferences(DaemonService.class, null);
            for (ServiceReference daemonServiceReference : daemonReferences) {
                DaemonService daemonService = (DaemonService)this.bundleContext.getService(daemonServiceReference);
                Bundle daemonBundle = daemonServiceReference.getBundle();
                DaemonImpl daemon = new DaemonImpl(daemonBundle, daemonService, this.daemonAdminService, this.extractionRegistration);
                daemonService.init((DaemonContribution)daemon);
                this.daemonAdminService.prepareDaemon(daemon);
                this.daemons.add(daemon);
            }
        }
        catch (InvalidSyntaxException e) {
            Log.error((String)"Problem with installation of bundle", (Throwable)e);
        }
        catch (IOException ioe) {
            Log.error((String)"Problem with installation of bundle", (Throwable)ioe);
        }
    }

    public void stopAllDaemonsForBundle(Bundle bundle) {
        for (DaemonImpl daemon : this.daemons) {
            if (!daemon.getBundle().equals(bundle)) continue;
            daemon.stop();
        }
    }
}

