/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.polyscope.urcaps.internal.daemonservice.AbstractDaemonAdminService;
import com.ur.polyscope.urcaps.internal.daemonservice.Daemon;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonAdminService;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.commandline.ScriptRunner;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class RUNITService
extends AbstractDaemonAdminService
implements DaemonAdminService {
    public static final String SERVICE = "service";
    private static final String TXT_LOG_DIR = "log";
    private static final String RUNIT_LOG_DIR = "log";

    @Override
    public void prepareDaemon(Daemon daemon) throws IOException {
        File executable = this.getExecutablePath(daemon);
        executable.getCanonicalFile().setExecutable(true);
        File runitPath = new File(String.valueOf(executable.getParent()) + File.separator + this.getExecutableHashCode(daemon));
        runitPath.mkdirs();
        this.createExecutableFile(new File(runitPath, "run"), this.getDaemonRunScript(executable.getCanonicalPath()));
        File logPath = new File(runitPath, "log");
        logPath.mkdirs();
        this.createExecutableFile(new File(logPath, "run"), this.getLogRunScript());
        new File(logPath, "log").mkdirs();
    }

    @Override
    protected File getServiceDirectory() throws IOException {
        File serviceDirectory = this.isOnRobot() ? new File(String.valueOf(File.separator) + "etc" + File.separator + SERVICE + File.separator) : (RUNITService.isOnURSimVM() ? new File(String.valueOf(System.getProperty("user.home")) + File.separator + SERVICE + File.separator) : (this.isOnMac() ? new File(String.valueOf(File.separator) + "Users" + File.separator + System.getProperty("user.name") + File.separator + SERVICE + File.separator) : new File(String.valueOf(File.separator) + "home" + File.separator + System.getProperty("user.name") + File.separator + SERVICE + File.separator)));
        this.ensureDirectoryExists(serviceDirectory);
        return serviceDirectory;
    }

    private File createExecutableFile(File file, String content) throws IOException {
        file.createNewFile();
        if (!file.setExecutable(true)) {
            throw new IOException("Could not set executable flag on file " + file.getAbsolutePath());
        }
        try (FileWriter writer = new FileWriter(file);){
            writer.write(content);
        }
        return file;
    }

    private String getDaemonRunScript(String executablePath) {
        StringBuilder result = new StringBuilder();
        result.append("#!/bin/sh\n");
        result.append("exec 2>&1\n");
        result.append("cd \"" + new File(executablePath).getParent() + File.separator + "\"\n");
        result.append("exec \"" + executablePath + "\"\n");
        return result.toString();
    }

    private String getLogRunScript() {
        StringBuilder result = new StringBuilder();
        result.append("#!/bin/sh\n");
        result.append("exec svlogd -tt ./log\n");
        return result.toString();
    }

    @Override
    public synchronized void start(Daemon daemon) {
        try {
            File symLinkFile = this.getSymLinkPath(daemon);
            if (symLinkFile.exists()) {
                return;
            }
            String symLinkPath = symLinkFile.getPath();
            File runitPath = new File(String.valueOf(this.getExecutablePath(daemon).getParent()) + File.separator + this.getExecutableHashCode(daemon));
            this.createSymLink(runitPath.getCanonicalPath(), symLinkPath);
        }
        catch (IOException iOException) {}
    }

    @Override
    public synchronized void stop(Daemon daemon) {
        try {
            File file = this.getSymLinkPath(daemon);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public boolean isRunning(Daemon daemon) {
        try {
            ScriptRunner runner = this.runSvCommand("status " + this.getSymLinkPath(daemon));
            String output = runner.getOutputString();
            if (output.startsWith("run")) {
                return this.determineIfProcessIsRunning(daemon, output);
            }
        }
        catch (IOException e) {
            Log.warning((String)("Exception occurred while tracking Daemon: " + e.getMessage()));
        }
        return false;
    }

    private boolean determineIfProcessIsRunning(Daemon daemon, String output) throws IOException {
        int startIndex = output.indexOf("(pid ") + 5;
        int stopIndex = output.indexOf(")", startIndex);
        if (startIndex != -1 && stopIndex != -1) {
            String pidStr = output.substring(startIndex, stopIndex).trim();
            BashScriptRunner psDaemon = new BashScriptRunner(String.format("ps -p %s -o args", pidStr), null, null);
            psDaemon.run();
            output = psDaemon.getOutputString().trim();
            String daemonPath = null;
            daemonPath = this.getExecutablePath(daemon).getCanonicalPath();
            return output.endsWith(daemonPath);
        }
        return false;
    }

    private File getSymLinkPath(Daemon daemon) throws IOException {
        return new File(this.getServiceDirectory(), this.getDaemonIdentifier(daemon));
    }

    private String getDaemonIdentifier(Daemon daemon) {
        return String.valueOf(AbstractDaemonAdminService.BUNDLE_START_TAG) + AbstractDaemonAdminService.SYMBOLIC_LINK_DELIMITER + daemon.getBundleSymbolicName() + AbstractDaemonAdminService.SYMBOLIC_LINK_DELIMITER + this.getExecutableHashCode(daemon);
    }

    private ScriptRunner runSvCommand(String arguments) {
        String command = "sv " + arguments;
        BashScriptRunner runner = new BashScriptRunner(command, null, null);
        runner.run();
        return runner;
    }
}

