/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.daemonservice;

import com.ur.polyscope.urcaps.internal.daemonservice.AbstractDaemonAdminService;
import com.ur.polyscope.urcaps.internal.daemonservice.Daemon;
import com.ur.polyscope.urcaps.internal.daemonservice.DaemonAdminService;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public class SystemdService
extends AbstractDaemonAdminService
implements DaemonAdminService {
    private final String SYSTEMCTL_USER = this.getSystemCtlCommand();

    private String getSystemCtlCommand() {
        if (this.isOnRobot()) {
            return "systemctl";
        }
        if (SystemdService.isOnURSimVM()) {
            return "systemctl";
        }
        if (this.isOnMac()) {
            return "systemctl";
        }
        return "systemctl --user";
    }

    @Override
    public void start(Daemon daemon) {
        try {
            this.runScript("start", this.getUnitFile(daemon));
        }
        catch (IOException e) {
            Log.error((String)"Failed to start service daemon", (Throwable)e);
        }
    }

    @Override
    public void stop(Daemon daemon) {
        try {
            this.runScript("stop", this.getUnitFile(daemon));
        }
        catch (IOException e) {
            Log.error((String)"Failed to stop service daemon", (Throwable)e);
        }
    }

    @Override
    public boolean isRunning(Daemon daemon) {
        try {
            BashScriptRunner status = this.runScript("-q is-active", this.getUnitFile(daemon));
            return status.getReturnVal() == 0;
        }
        catch (IOException e) {
            Log.error((String)"Failed to get status of service daemon", (Throwable)e);
            return false;
        }
    }

    @Override
    public void prepareDaemon(Daemon daemon) throws IOException {
        File executable = this.getExecutablePath(daemon);
        executable.setExecutable(true);
        File serviceFile = this.createServiceFile(executable, daemon);
        this.createSymlinkFromServiceFile(serviceFile);
        this.runScript("daemon-reload", "");
    }

    private BashScriptRunner runScript(String command, String argument) throws IOException {
        BashScriptRunner runner = new BashScriptRunner(String.format("%s %s %s", this.SYSTEMCTL_USER, command, argument), null, null);
        runner.execute();
        return runner;
    }

    private void createSymlinkFromServiceFile(File serviceFile) throws IOException {
        File symLink = new File(this.getServiceDirectory() + File.separator + serviceFile.getName());
        if (!symLink.exists()) {
            this.createSymLink(serviceFile.getCanonicalPath(), symLink.getCanonicalPath());
        }
    }

    String getUnitFile(Daemon daemon) {
        return String.valueOf(AbstractDaemonAdminService.BUNDLE_START_TAG) + AbstractDaemonAdminService.SYMBOLIC_LINK_DELIMITER + daemon.getBundleSymbolicName() + AbstractDaemonAdminService.SYMBOLIC_LINK_DELIMITER + this.getExecutableHashCode(daemon) + ".service";
    }

    File createServiceFile(File executable, Daemon daemon) throws IOException {
        File file = new File(String.valueOf(executable.getParent()) + File.separator + this.getUnitFile(daemon));
        Throwable throwable = null;
        Object var5_6 = null;
        try (OutputStreamWriter writer = new OutputStreamWriter(Files.newOutputStream(file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8);){
            writer.write(String.format("[Unit]%n", new Object[0]));
            writer.write(String.format("Description=URCap Daemon %s Service (%s)%n", daemon.getBundleSymbolicName(), daemon.getExecutable()));
            writer.write(String.format("%n", new Object[0]));
            writer.write(String.format("StartLimitIntervalSec=60%n", new Object[0]));
            writer.write(String.format("StartLimitBurst=5%n", new Object[0]));
            writer.write(String.format("%n", new Object[0]));
            writer.write(String.format("[Service]%n", new Object[0]));
            writer.write(String.format("WorkingDirectory=%s%n", String.valueOf(executable.getParentFile().getCanonicalPath()) + File.separator));
            writer.write(String.format("ExecStart=%s%n", executable.getCanonicalPath()));
            writer.write(String.format("Restart=always%n", new Object[0]));
            writer.write(String.format("RestartSec=3%n", new Object[0]));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return file;
    }

    @Override
    protected File getServiceDirectory() throws IOException {
        File serviceDirectory = this.isOnRobot() ? new File(String.valueOf(File.separator) + "lib" + File.separator + "systemd" + File.separator + "system" + File.separator) : (SystemdService.isOnURSimVM() ? new File(String.valueOf(File.separator) + "lib" + File.separator + "systemd" + File.separator + "system" + File.separator) : (this.isOnMac() ? new File(String.valueOf(File.separator) + "Users" + File.separator + System.getProperty("user.name") + File.separator + ".config" + File.separator + "systemd" + File.separator + "user" + File.separator) : new File(String.valueOf(File.separator) + "home" + File.separator + System.getProperty("user.name") + File.separator + ".config" + File.separator + "systemd" + File.separator + "user" + File.separator)));
        this.ensureDirectoryExists(serviceDirectory);
        return serviceDirectory;
    }
}

