/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.device;

import com.ur.polyscope.urcaps.device.DeviceManagerExtension;
import com.ur.polyscope.urcaps.device.DeviceRegistrationManagerProvider;
import com.ur.polyscope.urcaps.device.URCapDeviceRegistrationManagerProvider;
import com.ur.urcap.api.domain.device.DeviceRegistrationManager;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DeviceRegistrationManagerProviderImpl
implements URCapDeviceRegistrationManagerProvider {
    private Map<Class<? extends DeviceRegistrationManager>, DeviceRegistrationManagerProvider> deviceRegistrationManagerMap = new HashMap<Class<? extends DeviceRegistrationManager>, DeviceRegistrationManagerProvider>();

    @Inject
    public DeviceRegistrationManagerProviderImpl() {
    }

    public void registerExtension(DeviceManagerExtension extension) {
        Class managerClass = extension.getManagerClass();
        DeviceRegistrationManagerProvider provider = extension.getManagerProvider();
        this.deviceRegistrationManagerMap.put(managerClass, provider);
    }

    public <T extends DeviceRegistrationManager> T get(Class<T> deviceRegistrationManagerClass, Class<?> serviceClass) {
        DeviceRegistrationManagerProvider provider = this.deviceRegistrationManagerMap.get(deviceRegistrationManagerClass);
        DeviceRegistrationManager manager = provider.get(serviceClass);
        return (T)manager;
    }
}

