/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.device;

import com.ur.polyscope.urcaps.device.URCapServiceProvider;
import com.ur.polyscope.urcaps.nodeservices.URCapClassResolver;
import com.ur.urcap.api.contribution.URCapProgramNodeService;
import com.ur.urcap.api.domain.URCapInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class URCapServiceProviderImpl
implements URCapServiceProvider {
    private Map<Class<?>, URCapProgramNodeService> services = new HashMap();
    private Map<Class<?>, URCapInfo> infos = new HashMap();

    public void addProgramNodeService(URCapProgramNodeService service, URCapInfo info) {
        Class serviceClass = URCapClassResolver.getURCapClass((URCapProgramNodeService)service);
        this.services.put(serviceClass, service);
        this.infos.put(serviceClass, info);
    }

    public List<URCapProgramNodeService> getProgramServices() {
        return Collections.unmodifiableList(new ArrayList<URCapProgramNodeService>(this.services.values()));
    }

    public URCapInfo getURCapInfo(Class<?> serviceClass) {
        return this.infos.get(serviceClass);
    }

    public URCapProgramNodeService getProgramNodeService(Class<?> serviceClass) {
        return this.services.get(serviceClass);
    }
}

