/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.dockerregistry.client;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.ur.polyscope.urcaps.URCapZipInfo;
import com.ur.util.logging.Log;
import java.io.File;
import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public final class URServiceRESTClient {
    protected static String ARTIFACT_URI = "http://localhost/universal-robots/urservice/api/v1/artifacts";

    private URServiceRESTClient() {
    }

    public static URCapZipInfo getURCapIdentificationFromArtifact(String artifactType, String resourceId) throws IOException, HttpException {
        return URServiceRESTClient.getFromResource(ARTIFACT_URI, artifactType, resourceId, URCapZipInfo.class);
    }

    public static String getArtifactIdFromResource(String artifactType, String resourceId) throws IOException, HttpException {
        return URServiceRESTClient.getFromResource(ARTIFACT_URI, artifactType, resourceId, ArtifactWrapper.class).getArtifactID();
    }

    private static <T> T getFromResource(String uri, String artifactType, String resourceId, Class<T> wrapper) throws IOException, HttpException {
        Object object;
        CloseableHttpClient httpClient = null;
        CloseableHttpResponse response = null;
        String filename = new File(resourceId).getName();
        String commandUri = String.format("%s/%s/%s?fileName=%s", uri, artifactType, "info", filename);
        HttpGet httpGet = new HttpGet(commandUri);
        try {
            httpClient = HttpClients.createDefault();
            response = httpClient.execute((HttpUriRequest)httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            String responseString = EntityUtils.toString((HttpEntity)response.getEntity());
            if (statusCode != 200) {
                throw new HttpException("Failed to get URCap information: " + responseString + ": HTTP error code : " + statusCode);
            }
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            object = mapper.readValue(responseString, wrapper);
        }
        catch (IOException | HttpException ex) {
            try {
                throw ex;
            }
            catch (Throwable throwable) {
                URServiceRESTClient.closeResponse(response);
                URServiceRESTClient.closeHttpClient(httpClient);
                throw throwable;
            }
        }
        URServiceRESTClient.closeResponse(response);
        URServiceRESTClient.closeHttpClient(httpClient);
        return (T)object;
    }

    private static void closeHttpClient(CloseableHttpClient httpClient) {
        if (httpClient != null) {
            try {
                httpClient.close();
            }
            catch (IOException e) {
                Log.error((String)"Could not close Http Client", (Throwable)e);
            }
        }
    }

    private static void closeResponse(CloseableHttpResponse response) {
        if (response != null) {
            try {
                response.close();
            }
            catch (IOException e) {
                Log.error((String)"Could not close Http Response", (Throwable)e);
            }
        }
    }

    private static class ArtifactWrapper {
        @JsonProperty(value="artifact-id")
        private String artifactID;

        private ArtifactWrapper() {
        }

        public String getArtifactID() {
            return this.artifactID;
        }

        public void setArtifactID(String artifactID) {
            this.artifactID = artifactID;
        }
    }
}

