/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.flightreport;

import com.ur.polyscope.flightrecorder.FlightRecorderProbe;
import com.ur.polyscope.flightrecorder.FlightRecorderTriggerType;
import com.ur.polyscope.flightrecorder.attachment.FlightRecorderAttachment;
import com.ur.polyscope.urcaps.contributions.ContributionSet;
import com.ur.polyscope.urcaps.contributions.URCap;
import com.ur.polyscope.urcaps.contributions.URCapInformation;
import java.io.PrintStream;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;

public class URCapContributionsProbe
implements FlightRecorderProbe {
    private ContributionSet contributionSet;

    @Inject
    public URCapContributionsProbe(ContributionSet contributionSet) {
        this.contributionSet = contributionSet;
    }

    public String getName() {
        return "URCap Contributions";
    }

    public void write(PrintStream printStream) {
        HashMap<String, URCapInformation> bundleNameToURCapInfo = new HashMap<String, URCapInformation>();
        for (URCap each : this.contributionSet.getContributions()) {
            URCapInformation information = each.getURCapInformation();
            bundleNameToURCapInfo.put(information.getBundleAttribute("Bundle-Name"), information);
        }
        for (URCap each : bundleNameToURCapInfo.values()) {
            printStream.println(each.reportToString());
        }
    }

    public List<FlightRecorderAttachment> getFileAttachments() {
        return Collections.emptyList();
    }

    public void start() {
    }

    public void stop() {
    }

    public Set<FlightRecorderTriggerType> getApplicableReportTypes() {
        return EnumSet.allOf(FlightRecorderTriggerType.class);
    }
}

