/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.home.config;

import com.ur.polyscope.program.nodes.home.HomeNode;
import com.ur.polyscope.program.nodes.home.HomeNodeType;
import com.ur.polyscope.urcaps.internal.programnodes.home.apiincubator.HomeNodeConfig;
import com.ur.polyscope.urcaps.internal.programnodes.home.apiincubator.HomeSpeedAndAccelerationNodeConfig;
import com.ur.polyscope.urcaps.internal.programnodes.home.apiincubator.HomeTimeNodeConfig;
import com.ur.polyscope.urcaps.internal.programnodes.home.config.HomeNodeConfigInternalUnits;
import com.ur.polyscope.urcaps.internal.programnodes.home.config.HomeSpeedAndAccelerationNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.home.config.HomeTimeNodeConfigImpl;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Time;
import javax.inject.Inject;

public class HomeNodeConfigExtractor
implements HomeNodeConfigInternalUnits {
    private final SimpleValueFactory simpleValueFactory;

    @Inject
    public HomeNodeConfigExtractor(SimpleValueFactory simpleValueFactory) {
        this.simpleValueFactory = simpleValueFactory;
    }

    public HomeNodeConfig extractHomeNodeConfig(HomeNode realNode) {
        HomeNodeType type = realNode.getHomeNodeType();
        switch (type) {
            case SPEED_AND_ACCELERATION: {
                return this.extractHomeSpeedAndAccelerationNodeConfig(realNode);
            }
            case TIME: {
                return this.extractHomeTimeNodeConfig(realNode);
            }
        }
        return this.extractHomeSpeedAndAccelerationNodeConfig(realNode);
    }

    public HomeTimeNodeConfig extractHomeTimeNodeConfig(HomeNode realNode) {
        double defaultTime = realNode.getMotionTime();
        Time time = this.simpleValueFactory.createTime(defaultTime, HomeNodeConfigInternalUnits.INTERNAL_TIME_UNIT);
        return new HomeTimeNodeConfigImpl(time);
    }

    public HomeSpeedAndAccelerationNodeConfig extractHomeSpeedAndAccelerationNodeConfig(HomeNode realNode) {
        double defaultSpeed = realNode.getSpeed();
        AngularSpeed speed = this.simpleValueFactory.createAngularSpeed(defaultSpeed, HomeNodeConfigInternalUnits.INTERNAL_SPEED_UNIT);
        double defaultAcceleration = realNode.getAcceleration();
        AngularAcceleration acceleration = this.simpleValueFactory.createAngularAcceleration(defaultAcceleration, HomeNodeConfigInternalUnits.INTERNAL_ACCELERATION_UNIT);
        return new HomeSpeedAndAccelerationNodeConfigImpl(speed, acceleration);
    }
}

