/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.move;

import com.google.inject.Inject;
import com.ur.polyscope.geomfeature.FeatureService;
import com.ur.polyscope.geomfeature.SpatialFeature;
import com.ur.polyscope.geomfeature.SpatialFeatureReference;
import com.ur.polyscope.geomfeature.urcaps.FeatureWrapService;
import com.ur.polyscope.program.nodes.move.MoveJNode;
import com.ur.polyscope.program.nodes.move.MoveLNode;
import com.ur.polyscope.program.nodes.move.MoveNode;
import com.ur.polyscope.program.nodes.move.MovePNode;
import com.ur.polyscope.program.nodes.move.PositionType;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ThrowIfNonCompoundProgramChanges;
import com.ur.polyscope.tcp.TCPInternal;
import com.ur.polyscope.tcp.TCPRef;
import com.ur.polyscope.tcp.TCPType;
import com.ur.polyscope.tcp.urcap.TCPFactory;
import com.ur.polyscope.urcaps.domain.value.AccelerationImpl;
import com.ur.polyscope.urcaps.domain.value.AngularAccelerationImpl;
import com.ur.polyscope.urcaps.domain.value.AngularSpeedImpl;
import com.ur.polyscope.urcaps.domain.value.LengthImpl;
import com.ur.polyscope.urcaps.domain.value.SpeedImpl;
import com.ur.polyscope.urcaps.internal.aspects.IgnoreProgramChangesAspect;
import com.ur.polyscope.urcaps.internal.aspects.ThrowIfNonCompoundProgramChangesAspect;
import com.ur.polyscope.urcaps.internal.programnodes.AbstractProgramNode;
import com.ur.polyscope.urcaps.internal.programnodes.blend.BlendImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveJMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveJMoveNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveLMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveLMoveNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeConfigFactoryImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeFeatureImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure1;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure11;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure13;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure3;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure7;
import com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl$AjcClosure9;
import com.ur.polyscope.urcaps.internal.programnodes.move.MovePMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.MovePMoveNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.move.UnresolvedFeatureSelectionImpl;
import com.ur.polyscope.urcaps.programnodes.MoveJMoveNodeConfigEx;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.aspects.UncaughtExceptionAspect;
import com.ur.urcap.api.domain.feature.Feature;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.FeatureSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveJMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveLMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfigFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeFeature;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeTCP;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MovePMoveNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.TCPSelection;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.TCPSelectionFactory;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.builder.MoveNodeConfigBuilders;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.optimove.OptiMoveMoveNodeConfig;
import com.ur.urcap.api.domain.program.structure.ProgramNodeVisitor;
import com.ur.urcap.api.domain.tcp.TCP;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Speed;
import java.util.Objects;
import javax.inject.Provider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MoveNodeImpl
extends AbstractProgramNode<MoveNode>
implements com.ur.urcap.api.domain.program.nodes.builtin.MoveNode {
    private final MoveNodeConfigFactoryImpl moveNodeConfigFactory;
    private final FeatureService featureService;
    private final FeatureWrapService featureWrapService;
    private final MoveNodeConfigBuilders moveNodeConfigBuilders;
    private final TCPSelectionFactory tcpSelectionFactory;
    private final TCPFactory tcpFactory;
    private MoveNodeConfig config;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;

    @Inject
    public MoveNodeImpl(Provider<MoveNodeConfigFactory> moveNodeConfigFactoryProvider, FeatureService featureService, Provider<MoveNode> moveNodeProvider, MoveNodeConfigBuilders moveNodeConfigBuilders, TCPSelectionFactory tcpSelectionFactory, TCPFactory tcpFactory, FeatureWrapService featureWrapService) {
        super(moveNodeProvider);
        this.moveNodeConfigFactory = this.createMoveNodeConfigFactory(moveNodeConfigFactoryProvider);
        this.featureService = featureService;
        this.moveNodeConfigBuilders = moveNodeConfigBuilders;
        this.tcpSelectionFactory = tcpSelectionFactory;
        this.tcpFactory = tcpFactory;
        this.featureWrapService = featureWrapService;
    }

    @IgnoreProgramChanges
    private MoveNodeConfigFactoryImpl createMoveNodeConfigFactory(Provider<MoveNodeConfigFactory> moveNodeConfigFactoryProvider) {
        Provider<MoveNodeConfigFactory> provider = moveNodeConfigFactoryProvider;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, provider);
        Object[] objectArray = new Object[]{this, provider, joinPoint};
        MoveNodeImpl$AjcClosure1 moveNodeImpl$AjcClosure1 = new MoveNodeImpl$AjcClosure1(objectArray);
        return (MoveNodeConfigFactoryImpl)IgnoreProgramChangesAspect.aspectOf().aroundAnnotatedMethod(moveNodeImpl$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    @Override
    protected void initializeRealNode(MoveNode realNode) {
        if (this.config == null) {
            return;
        }
        this.applyConfig(realNode, this.config);
    }

    private void applyConfig(MoveNode realNode, MoveNodeConfig config) {
        switch (config.getConfigType()) {
            case MOVE_J: {
                this.applyMoveJConfig(realNode, (MoveJMoveNodeConfigEx)config);
                break;
            }
            case MOVE_L: {
                this.applyMoveLConfig(realNode, (MoveLMoveNodeConfig)config);
                break;
            }
            case MOVE_P: {
                this.applyMovePConfig(realNode, (MovePMoveNodeConfig)config);
                break;
            }
            case OPTI_MOVE: {
                this.applyOptiMoveConfig(realNode, (OptiMoveMoveNodeConfig)config);
                break;
            }
            default: {
                throw new IllegalArgumentException("Node type not supported: " + config.getConfigType());
            }
        }
    }

    private void applyOptiMoveConfig(MoveNode realNode, OptiMoveMoveNodeConfig config) {
        TCPSelection tcpSelection = config.getTCPSelection();
        TCPType tcpType = this.getTCPTypeFromTCPSelection(tcpSelection);
        TCPRef tcpRef = null;
        if (tcpType == TCPType.TCP) {
            tcpRef = ((TCPInternal)((MoveNodeTCP)tcpSelection).getTCP()).getTCPRef();
        }
        Percentage speedPercentage = (Percentage)config.getMotionParameters().getSpeedPercentage();
        Percentage accelerationPercentage = (Percentage)config.getMotionParameters().getAccelerationPercentage();
        if (config.getMoveType().equals((Object)OptiMoveMoveNodeConfig.MotionType.MOVE_L)) {
            MoveLNode moveLNode = (MoveLNode)realNode.convertTo(MoveLNode.class);
            moveLNode.setOptiMoveSpeed(speedPercentage);
            moveLNode.setOptiMoveAcceleration(accelerationPercentage);
            moveLNode.setFeatureReference(this.getFeatureReference(config.getFeatureSelection()));
            if (tcpType == TCPType.TCP) {
                moveLNode.setTCPRef(tcpRef);
            } else {
                moveLNode.setTCPType(tcpType);
            }
        } else if (Objects.equals(config.getMoveType(), OptiMoveMoveNodeConfig.MotionType.MOVE_J)) {
            MoveJNode moveJNode = (MoveJNode)realNode.convertTo(MoveJNode.class);
            moveJNode.setOptiMoveSpeed(speedPercentage);
            moveJNode.setOptiMoveAcceleration(accelerationPercentage);
            moveJNode.setFeatureReference(this.getFeatureReference(config.getFeatureSelection()));
            if (tcpType == TCPType.TCP) {
                moveJNode.setTCPRef(tcpRef);
            } else {
                moveJNode.setTCPType(tcpType);
            }
        }
    }

    private void applyMoveJConfig(MoveNode realNode, MoveJMoveNodeConfigEx moveJMoveNodeConfig) {
        MoveJNode moveJNode = (MoveJNode)realNode.convertTo(MoveJNode.class);
        MoveJMotionParameters motionParameters = moveJMoveNodeConfig.getMotionParameters();
        moveJNode.setJointSpeed(motionParameters.getJointSpeed().getAs(AngularSpeed.Unit.RAD_S));
        moveJNode.setJointAcceleration(motionParameters.getJointAcceleration().getAs(AngularAcceleration.Unit.RAD_S2));
        FeatureSelection featureSelection = moveJMoveNodeConfig.getFeatureSelection();
        moveJNode.setFeatureReference(this.getFeatureReference(featureSelection));
        TCPSelection tcpSelection = moveJMoveNodeConfig.getTCPSelection();
        TCPType tcpType = this.getTCPTypeFromTCPSelection(tcpSelection);
        if (tcpType == TCPType.TCP) {
            moveJNode.setTCPRef(((TCPInternal)((MoveNodeTCP)tcpSelection).getTCP()).getTCPRef());
        } else {
            moveJNode.setTCPType(tcpType);
        }
        moveJNode.setPositionType(moveJMoveNodeConfig.getPositionType());
    }

    private void applyMoveLConfig(MoveNode realNode, MoveLMoveNodeConfig moveLMoveNodeConfig) {
        MoveLNode moveLNode = (MoveLNode)realNode.convertTo(MoveLNode.class);
        moveLNode.setToolSpeed(moveLMoveNodeConfig.getMotionParameters().getToolSpeed().getAs(Speed.Unit.M_S));
        moveLNode.setToolAcceleration(moveLMoveNodeConfig.getMotionParameters().getToolAcceleration().getAs(Acceleration.Unit.M_S2));
        moveLNode.setFeatureReference(this.getFeatureReference(moveLMoveNodeConfig.getFeatureSelection()));
        TCPSelection tcpSelection = moveLMoveNodeConfig.getTCPSelection();
        TCPType tcpType = this.getTCPTypeFromTCPSelection(tcpSelection);
        if (tcpType == TCPType.TCP) {
            moveLNode.setTCPRef(((TCPInternal)((MoveNodeTCP)tcpSelection).getTCP()).getTCPRef());
        } else {
            moveLNode.setTCPType(tcpType);
        }
    }

    private void applyMovePConfig(MoveNode realNode, MovePMoveNodeConfig movePMoveNodeConfig) {
        MovePNode movePNode = (MovePNode)realNode.convertTo(MovePNode.class);
        movePNode.setToolSpeed(movePMoveNodeConfig.getMotionParameters().getToolSpeed().getAs(Speed.Unit.M_S));
        movePNode.setToolAcceleration(movePMoveNodeConfig.getMotionParameters().getToolAcceleration().getAs(Acceleration.Unit.M_S2));
        movePNode.setFeatureReference(this.getFeatureReference(movePMoveNodeConfig.getFeatureSelection()));
        movePNode.setBlend(movePMoveNodeConfig.getMotionParameters().getBlend().getRadiusLength().getAs(Length.Unit.M));
        TCPSelection tcpSelection = movePMoveNodeConfig.getTCPSelection();
        TCPType tcpType = this.getTCPTypeFromTCPSelection(tcpSelection);
        if (tcpType == TCPType.TCP) {
            movePNode.setTCPRef(((TCPInternal)((MoveNodeTCP)tcpSelection).getTCP()).getTCPRef());
        } else {
            movePNode.setTCPType(tcpType);
        }
    }

    private TCPType getTCPTypeFromTCPSelection(TCPSelection tcpSelection) {
        TCPType tcpType;
        switch (tcpSelection.getType()) {
            case TCP: {
                tcpType = TCPType.TCP;
                break;
            }
            case USE_ACTIVE_TCP: {
                tcpType = TCPType.ACTIVE_TCP;
                break;
            }
            case IGNORE_ACTIVE_TCP: {
                tcpType = TCPType.TOOL_FLANGE;
                break;
            }
            default: {
                throw new IllegalArgumentException("TCPSelection type not supported " + tcpSelection);
            }
        }
        return tcpType;
    }

    public void doVisit(int i, int depth, ProgramNodeVisitor nodeVisitor) {
        nodeVisitor.visit((com.ur.urcap.api.domain.program.nodes.builtin.MoveNode)this, i, depth);
    }

    public MoveNodeConfigFactory getConfigFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MoveNodeImpl$AjcClosure3 moveNodeImpl$AjcClosure3 = new MoveNodeImpl$AjcClosure3(objectArray);
        return (MoveNodeConfigFactory)UncaughtExceptionAspect.aspectOf().aroundMethod(moveNodeImpl$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @ThrowIfNonCompoundProgramChanges
    public synchronized com.ur.urcap.api.domain.program.nodes.builtin.MoveNode setConfig(MoveNodeConfig moveNodeConfig) {
        Object object;
        MoveNodeConfig moveNodeConfig2 = moveNodeConfig;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this, (Object)moveNodeConfig2);
        Object[] objectArray = new Object[]{this, moveNodeConfig2, joinPoint};
        MoveNodeImpl$AjcClosure7 moveNodeImpl$AjcClosure7 = new MoveNodeImpl$AjcClosure7(objectArray);
        try {
            object = UncaughtExceptionAspect.aspectOf().aroundMethod(moveNodeImpl$AjcClosure7.linkStackClosureAndJoinPoint(69648));
            moveNodeImpl$AjcClosure7.unlink();
        }
        catch (Throwable throwable) {
            moveNodeImpl$AjcClosure7.unlink();
            throw throwable;
        }
        return (com.ur.urcap.api.domain.program.nodes.builtin.MoveNode)object;
    }

    public synchronized MoveNodeConfig getConfig() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MoveNodeImpl$AjcClosure9 moveNodeImpl$AjcClosure9 = new MoveNodeImpl$AjcClosure9(objectArray);
        return (MoveNodeConfig)UncaughtExceptionAspect.aspectOf().aroundMethod(moveNodeImpl$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    public MoveNodeConfigBuilders getConfigBuilders() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MoveNodeImpl$AjcClosure11 moveNodeImpl$AjcClosure11 = new MoveNodeImpl$AjcClosure11(objectArray);
        return (MoveNodeConfigBuilders)UncaughtExceptionAspect.aspectOf().aroundMethod(moveNodeImpl$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    public TCPSelectionFactory getTCPSelectionFactory() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        MoveNodeImpl$AjcClosure13 moveNodeImpl$AjcClosure13 = new MoveNodeImpl$AjcClosure13(objectArray);
        return (TCPSelectionFactory)UncaughtExceptionAspect.aspectOf().aroundMethod(moveNodeImpl$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    private SpatialFeatureReference getFeatureReference(FeatureSelection moveNodeFeatureSelection) {
        if (moveNodeFeatureSelection.getType() == FeatureSelection.SelectionType.UNRESOLVED_FEATURE) {
            if (moveNodeFeatureSelection instanceof UnresolvedFeatureSelectionImpl) {
                return ((UnresolvedFeatureSelectionImpl)moveNodeFeatureSelection).getSpatialFeatureReference();
            }
            return null;
        }
        MoveNodeFeature featureSelection = (MoveNodeFeature)moveNodeFeatureSelection;
        SpatialFeature feature = this.featureWrapService.unwrapFeature(featureSelection.getFeature());
        SpatialFeatureReference spatialFeatureReference = feature.isVariable() ? this.featureService.getFeatureVariable(feature) : this.featureService.getFeatureReference(feature);
        return spatialFeatureReference;
    }

    private MoveNodeConfig getActualConfig() {
        MoveNode realProgramNode = (MoveNode)this.getRealProgramNode();
        if (realProgramNode.getType() == MoveJNode.class) {
            return MoveNodeImpl.getMoveJMoveNodeConfigFromRealNode((MoveJNode)realProgramNode.convertTo(MoveJNode.class), this.tcpSelectionFactory, this.tcpFactory, this.featureWrapService);
        }
        if (realProgramNode.getType() == MoveLNode.class) {
            return MoveNodeImpl.getMoveLMoveNodeConfigFromRealNode((MoveLNode)realProgramNode.convertTo(MoveLNode.class), this.tcpSelectionFactory, this.tcpFactory, this.featureWrapService);
        }
        if (realProgramNode.getType() == MovePNode.class) {
            return MoveNodeImpl.getMovePMoveNodeConfigFromRealNode((MovePNode)realProgramNode.convertTo(MovePNode.class), this.tcpSelectionFactory, this.tcpFactory, this.featureWrapService);
        }
        return this.moveNodeConfigFactory.createMoveJConfig();
    }

    public static MoveJMoveNodeConfigEx getMoveJMoveNodeConfigFromRealNode(MoveJNode realProgramNode, TCPSelectionFactory tcpSelectionFactory, TCPFactory tcpFactory, FeatureWrapService featureWrapService) {
        AngularSpeedImpl angularSpeed = new AngularSpeedImpl(realProgramNode.getJointSpeed(), AngularSpeed.Unit.RAD_S);
        AngularAccelerationImpl angularAcceleration = new AngularAccelerationImpl(Double.valueOf(realProgramNode.getJointAcceleration()), AngularAcceleration.Unit.RAD_S2);
        MoveJMotionParametersImpl moveJMotionParameters = new MoveJMotionParametersImpl((AngularSpeed)angularSpeed, (AngularAcceleration)angularAcceleration);
        FeatureSelection featureSelection = MoveNodeImpl.createFeatureSelection(realProgramNode.getFeatureReference(), featureWrapService);
        TCPSelection tcpSelection = MoveNodeImpl.createTCPSelection(realProgramNode.getTCPType(), realProgramNode.getTCPRef(), tcpSelectionFactory, tcpFactory);
        PositionType positionType = realProgramNode.getPositionType();
        return new MoveJMoveNodeConfigImpl(moveJMotionParameters, featureSelection, tcpSelection, positionType);
    }

    public static MoveLMoveNodeConfig getMoveLMoveNodeConfigFromRealNode(MoveLNode realProgramNode, TCPSelectionFactory tcpSelectionFactory, TCPFactory tcpFactory, FeatureWrapService featureWrapService) {
        SpeedImpl speed = new SpeedImpl(realProgramNode.getToolSpeed(), Speed.Unit.M_S);
        AccelerationImpl acceleration = new AccelerationImpl(Double.valueOf(realProgramNode.getToolAcceleration()), Acceleration.Unit.M_S2);
        FeatureSelection featureSelection = MoveNodeImpl.createFeatureSelection(realProgramNode.getFeatureReference(), featureWrapService);
        MoveLMotionParametersImpl moveLMotionParameters = new MoveLMotionParametersImpl((Speed)speed, (Acceleration)acceleration);
        TCPSelection tcpSelection = MoveNodeImpl.createTCPSelection(realProgramNode.getTCPType(), realProgramNode.getTCPRef(), tcpSelectionFactory, tcpFactory);
        return new MoveLMoveNodeConfigImpl(moveLMotionParameters, featureSelection, tcpSelection);
    }

    public static MovePMoveNodeConfig getMovePMoveNodeConfigFromRealNode(MovePNode realProgramNode, TCPSelectionFactory tcpSelectionFactory, TCPFactory tcpFactory, FeatureWrapService featureWrapService) {
        SpeedImpl speed = new SpeedImpl(realProgramNode.getToolSpeed(), Speed.Unit.M_S);
        AccelerationImpl acceleration = new AccelerationImpl(Double.valueOf(realProgramNode.getToolAcceleration()), Acceleration.Unit.M_S2);
        BlendImpl blend = new BlendImpl((Length)new LengthImpl(realProgramNode.getBlend(), Length.Unit.M));
        FeatureSelection featureSelection = MoveNodeImpl.createFeatureSelection(realProgramNode.getFeatureReference(), featureWrapService);
        MovePMotionParametersImpl movePMotionParameters = new MovePMotionParametersImpl((Speed)speed, (Acceleration)acceleration, blend);
        TCPSelection tcpSelection = MoveNodeImpl.createTCPSelection(realProgramNode.getTCPType(), realProgramNode.getTCPRef(), tcpSelectionFactory, tcpFactory);
        return new MovePMoveNodeConfigImpl(movePMotionParameters, featureSelection, tcpSelection);
    }

    private static FeatureSelection createFeatureSelection(SpatialFeatureReference featureReference, FeatureWrapService featureWrapService) {
        Feature feature = featureWrapService.wrapFeature(featureReference);
        if (feature == null) {
            return new UnresolvedFeatureSelectionImpl(featureReference);
        }
        return new MoveNodeFeatureImpl(feature);
    }

    private static TCPSelection createTCPSelection(TCPType tcpType, TCPRef tcpRef, TCPSelectionFactory tcpSelectionFactory, TCPFactory tcpFactory) {
        TCPSelection tcpSelection;
        switch (tcpType) {
            case TCP: {
                TCP tcp = tcpFactory.createTCPWrapper(tcpRef);
                tcpSelection = tcpSelectionFactory.createTCPSelection(tcp);
                break;
            }
            case TOOL_FLANGE: {
                tcpSelection = tcpSelectionFactory.createIgnoreActiveTCPSelection();
                break;
            }
            case ACTIVE_TCP: {
                tcpSelection = tcpSelectionFactory.createActiveTCPSelection();
                break;
            }
            default: {
                throw new IllegalArgumentException("TCPType not supported " + tcpType);
            }
        }
        return tcpSelection;
    }

    static {
        MoveNodeImpl.ajc$preClinit();
    }

    static final /* synthetic */ MoveNodeConfigFactoryImpl createMoveNodeConfigFactory_aroundBody0(MoveNodeImpl ajc$this, Provider moveNodeConfigFactoryProvider, JoinPoint joinPoint) {
        return (MoveNodeConfigFactoryImpl)moveNodeConfigFactoryProvider.get();
    }

    static final /* synthetic */ MoveNodeConfigFactory getConfigFactory_aroundBody2(MoveNodeImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.moveNodeConfigFactory;
    }

    private static final /* synthetic */ com.ur.urcap.api.domain.program.nodes.builtin.MoveNode setConfig_aroundBody4(MoveNodeImpl ajc$this, MoveNodeConfig moveNodeConfig, JoinPoint joinPoint) {
        ajc$this.config = moveNodeConfig;
        MoveNode realNode = (MoveNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.initializeRealNode(realNode);
        }
        return ajc$this;
    }

    private static final /* synthetic */ Object setConfig_aroundBody5$advice(MoveNodeImpl ajc$this, MoveNodeConfig moveNodeConfig, JoinPoint thisJoinPoint, ThrowIfNonCompoundProgramChangesAspect ajc$aspectInstance, ProceedingJoinPoint joinPoint) {
        ThrowIfNonCompoundProgramChangesAspect.ajc$inlineAccessFieldGet$com_ur_polyscope_urcaps_internal_aspects_ThrowIfNonCompoundProgramChangesAspect$com_ur_polyscope_urcaps_internal_aspects_ThrowIfNonCompoundProgramChangesAspect$undoRedoManager().throwIfNonCompoundProgramChange();
        ProceedingJoinPoint proceedingJoinPoint = joinPoint;
        return MoveNodeImpl.setConfig_aroundBody4(ajc$this, moveNodeConfig, (JoinPoint)proceedingJoinPoint);
    }

    static final /* synthetic */ com.ur.urcap.api.domain.program.nodes.builtin.MoveNode setConfig_aroundBody6(MoveNodeImpl moveNodeImpl, MoveNodeConfig moveNodeConfig, JoinPoint joinPoint) {
        return (com.ur.urcap.api.domain.program.nodes.builtin.MoveNode)MoveNodeImpl.setConfig_aroundBody5$advice(moveNodeImpl, moveNodeConfig, joinPoint, ThrowIfNonCompoundProgramChangesAspect.aspectOf(), (ProceedingJoinPoint)joinPoint);
    }

    static final /* synthetic */ MoveNodeConfig getConfig_aroundBody8(MoveNodeImpl ajc$this, JoinPoint joinPoint) {
        MoveNode realNode = (MoveNode)ajc$this.getRealProgramNode();
        if (realNode != null) {
            ajc$this.config = ajc$this.getActualConfig();
        } else if (ajc$this.config == null) {
            ajc$this.config = ajc$this.moveNodeConfigFactory.getDefaultMoveConfig();
        }
        return ajc$this.config;
    }

    static final /* synthetic */ MoveNodeConfigBuilders getConfigBuilders_aroundBody10(MoveNodeImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.moveNodeConfigBuilders;
    }

    static final /* synthetic */ TCPSelectionFactory getTCPSelectionFactory_aroundBody12(MoveNodeImpl ajc$this, JoinPoint joinPoint) {
        return ajc$this.tcpSelectionFactory;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MoveNodeImpl.java", MoveNodeImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "createMoveNodeConfigFactory", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "javax.inject.Provider", "moveNodeConfigFactoryProvider", "", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeConfigFactoryImpl"), 83);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigFactory", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfigFactory"), 229);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "setConfig", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig", "moveNodeConfig", "", "com.ur.urcap.api.domain.program.nodes.builtin.MoveNode"), 235);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("21", "getConfig", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.MoveNodeConfig"), 245);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getConfigBuilders", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.builder.MoveNodeConfigBuilders"), 256);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTCPSelectionFactory", "com.ur.polyscope.urcaps.internal.programnodes.move.MoveNodeImpl", "", "", "", "com.ur.urcap.api.domain.program.nodes.builtin.configurations.movenode.TCPSelectionFactory"), 261);
    }
}

