/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.waypoint;

import com.ur.polyscope.program.nodes.waypoint.blend.Blend;
import com.ur.polyscope.program.nodes.waypoint.blend.NoBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.RadiusBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.SharedBlend;
import com.ur.polyscope.program.nodes.waypoint.motion.JointMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.Motion;
import com.ur.polyscope.program.nodes.waypoint.motion.OptiMoveMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.SharedMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.TimeMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.ToolMotion;
import com.ur.polyscope.urcaps.internal.programnodes.blend.BlendImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.JointMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.TimeMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.ToolMotionParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.WaypointBlendParametersImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.WaypointNodeConfigFactoryImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.optimove.OptiMoveMotionParametersImpl;
import com.ur.polyscope.urcaps.jointposition.JointPositionUtil;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointMotionParameters;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.PoseFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositionFactory;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Percentage;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Time;
import javax.inject.Inject;

public class PolyscopeToURCapConverter {
    private final SimpleValueFactory valueFactory;
    private final PoseFactory poseFactory;
    private JointPositionFactory factory;

    @Inject
    public PolyscopeToURCapConverter(SimpleValueFactory valueFactory, PoseFactory poseFactory) {
        this.valueFactory = valueFactory;
        this.poseFactory = poseFactory;
        this.factory = JointPositionUtil.getFactory();
    }

    public JointPositions convertJointConfigurationToJointPositions(JointConfiguration jc) {
        if (!jc.isDefined()) {
            return null;
        }
        return this.factory.createJointPositions(jc.getBase(), jc.getShoulder(), jc.getElbow(), jc.getWrist1(), jc.getWrist2(), jc.getWrist3(), Angle.Unit.RAD);
    }

    public Pose convertToolPositionToPose(ToolPosition toolPosition) {
        return this.poseFactory.createPose(toolPosition.getPositionX(), toolPosition.getPositionY(), toolPosition.getPositionZ(), toolPosition.getRotationX(), toolPosition.getRotationY(), toolPosition.getRotationZ(), Length.Unit.M, Angle.Unit.RAD);
    }

    public BlendParameters convertBlendToBlendParameters(Blend blendParameter) {
        Object blendParameters;
        if (blendParameter instanceof NoBlend) {
            blendParameters = WaypointNodeConfigFactoryImpl.NO_BLEND;
        } else if (blendParameter instanceof SharedBlend) {
            blendParameters = WaypointNodeConfigFactoryImpl.SHARED_BLEND;
        } else if (blendParameter instanceof RadiusBlend) {
            RadiusBlend radiusBlend = (RadiusBlend)blendParameter;
            Length radius = this.valueFactory.createLength(radiusBlend.getRadius(), Length.Unit.M);
            BlendImpl blend = new BlendImpl(radius);
            blendParameters = new WaypointBlendParametersImpl(blend);
        } else {
            throw new IllegalArgumentException("Can't convert blend parameter for unsupported type " + blendParameter);
        }
        return blendParameters;
    }

    public WaypointMotionParameters convertMotionToWaypointMotionParameters(Motion motion) {
        Object waypointMotionParameters;
        if (motion instanceof SharedMotion) {
            waypointMotionParameters = WaypointNodeConfigFactoryImpl.SHARED_MOTION;
        } else if (motion instanceof TimeMotion) {
            TimeMotion timeMotion = (TimeMotion)motion;
            Time time = this.valueFactory.createTime(timeMotion.getTime(), Time.Unit.S);
            waypointMotionParameters = new TimeMotionParametersImpl(time);
        } else if (motion instanceof JointMotion) {
            JointMotion jointMotion = (JointMotion)motion;
            AngularSpeed angularSpeed = this.valueFactory.createAngularSpeed(jointMotion.getJointSpeed(), AngularSpeed.Unit.RAD_S);
            AngularAcceleration angularAcceleration = this.valueFactory.createAngularAcceleration(jointMotion.getJointAcceleration(), AngularAcceleration.Unit.RAD_S2);
            waypointMotionParameters = new JointMotionParametersImpl(angularSpeed, angularAcceleration);
        } else if (motion instanceof ToolMotion) {
            ToolMotion toolMotion = (ToolMotion)motion;
            Speed cartesianSpeed = this.valueFactory.createSpeed(toolMotion.getToolSpeed(), Speed.Unit.M_S);
            Acceleration cartesianAcceleration = this.valueFactory.createAcceleration(toolMotion.getToolAcceleration(), Acceleration.Unit.M_S2);
            waypointMotionParameters = new ToolMotionParametersImpl(cartesianSpeed, cartesianAcceleration);
        } else if (motion instanceof OptiMoveMotion) {
            OptiMoveMotion optiMoveMotion = (OptiMoveMotion)motion;
            waypointMotionParameters = new OptiMoveMotionParametersImpl((Percentage)optiMoveMotion.getSpeedPercentage(), (Percentage)optiMoveMotion.getAccelerationPercentage());
        } else {
            throw new IllegalArgumentException("Can't convert motion parameters for unsupported motion type " + motion);
        }
        return waypointMotionParameters;
    }
}

