/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.waypoint;

import com.ur.polyscope.program.nodes.waypoint.blend.Blend;
import com.ur.polyscope.program.nodes.waypoint.blend.NoBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.RadiusBlend;
import com.ur.polyscope.program.nodes.waypoint.blend.SharedBlend;
import com.ur.polyscope.program.nodes.waypoint.motion.JointMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.Motion;
import com.ur.polyscope.program.nodes.waypoint.motion.OptiMoveMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.SharedMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.TimeMotion;
import com.ur.polyscope.program.nodes.waypoint.motion.ToolMotion;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.JointMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.TimeMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.ToolMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointBlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.optimove.OptiMoveMotionParameters;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.Position;
import com.ur.urcap.api.domain.value.Rotation;
import com.ur.urcap.api.domain.value.jointposition.JointPosition;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.domain.value.simple.Acceleration;
import com.ur.urcap.api.domain.value.simple.Angle;
import com.ur.urcap.api.domain.value.simple.AngularAcceleration;
import com.ur.urcap.api.domain.value.simple.AngularSpeed;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.Speed;
import com.ur.urcap.api.domain.value.simple.Time;
import javax.inject.Singleton;

@Singleton
public class URCapToPolyscopeConverter {
    public Blend convertBlendParameterToBlend(BlendParameters blendParameter) {
        NoBlend blend;
        BlendParameters.ParameterType blendType = blendParameter.getType();
        switch (blendType) {
            case NO_BLEND: {
                blend = new NoBlend();
                break;
            }
            case SHARED_BLEND: {
                blend = new SharedBlend();
                break;
            }
            case WAYPOINT_BLEND: {
                WaypointBlendParameters waypointBlendParameters = (WaypointBlendParameters)blendParameter;
                Length radius = waypointBlendParameters.getBlend().getRadiusLength();
                double radiusInM = radius.getAs(Length.Unit.M);
                blend = new RadiusBlend(radiusInM);
                break;
            }
            default: {
                throw new IllegalStateException("Not supported blend type:" + blendType);
            }
        }
        return blend;
    }

    public Motion convertWaypointMotionParametersToMotion(WaypointMotionParameters motionParameters) {
        SharedMotion motion;
        WaypointMotionParameters.ParameterType motionType = motionParameters.getType();
        switch (motionType) {
            case TIME_MOTION: {
                TimeMotionParameters timeMotionParameters = (TimeMotionParameters)motionParameters;
                TimeMotion timeMotion = new TimeMotion();
                timeMotion.setTime(timeMotionParameters.getTime().getAs(Time.Unit.S));
                motion = timeMotion;
                break;
            }
            case JOINT_MOTION: {
                JointMotionParameters jointMotionParameters = (JointMotionParameters)motionParameters;
                motion = new JointMotion(jointMotionParameters.getJointSpeed().getAs(AngularSpeed.Unit.RAD_S), jointMotionParameters.getJointAcceleration().getAs(AngularAcceleration.Unit.RAD_S2));
                break;
            }
            case TOOL_MOTION: {
                ToolMotionParameters toolMotionParameters = (ToolMotionParameters)motionParameters;
                motion = new ToolMotion(toolMotionParameters.getToolSpeed().getAs(Speed.Unit.M_S), toolMotionParameters.getToolAcceleration().getAs(Acceleration.Unit.M_S2));
                break;
            }
            case SHARED_MOTION: {
                motion = new SharedMotion();
                break;
            }
            case OPTI_MOVE_MOTION: {
                OptiMoveMotionParameters optiMoveMotionParameters = (OptiMoveMotionParameters)motionParameters;
                motion = new OptiMoveMotion((Percentage)optiMoveMotionParameters.getSpeedPercentage(), (Percentage)optiMoveMotionParameters.getAccelerationPercentage());
                break;
            }
            default: {
                throw new IllegalStateException("Not supported motion type:" + motionType);
            }
        }
        return motion;
    }

    public ToolPosition convertPoseToToolPosition(Pose pose) {
        Position position = pose.getPosition();
        Rotation rotation = pose.getRotation();
        ToolPosition toolPosition = new ToolPosition(position.getX(Length.Unit.M), position.getY(Length.Unit.M), position.getZ(Length.Unit.M), rotation.getRX(Angle.Unit.RAD), rotation.getRY(Angle.Unit.RAD), rotation.getRZ(Angle.Unit.RAD));
        return toolPosition;
    }

    public JointConfiguration convertJointPositionsToJointConfiguration(JointPositions jointPositions) {
        JointPosition[] allJointPositions = jointPositions.getAllJointPositions();
        JointConfiguration jointConfiguration = new JointConfiguration(allJointPositions[0].getPosition(Angle.Unit.RAD), allJointPositions[1].getPosition(Angle.Unit.RAD), allJointPositions[2].getPosition(Angle.Unit.RAD), allJointPositions[3].getPosition(Angle.Unit.RAD), allJointPositions[4].getPosition(Angle.Unit.RAD), allJointPositions[5].getPosition(Angle.Unit.RAD));
        return jointConfiguration;
    }
}

