/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.waypoint;

import com.ur.polyscope.move.InverseKinematicProvider;
import com.ur.polyscope.program.nodes.waypoint.FixedWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.RelativeWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.VariableWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.WaypointNode;
import com.ur.polyscope.program.nodes.waypoint.blend.Blend;
import com.ur.polyscope.program.nodes.waypoint.motion.Motion;
import com.ur.polyscope.program.variables.Variable;
import com.ur.polyscope.program.variables.VariableConverter;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.FixedPositionDefinedWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.FixedPositionWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.RelativePositionWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.URCapToPolyscopeConverter;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.VariablePositionWaypointNodeConfigImpl;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.Position;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.urcap.api.domain.program.nodes.builtin.UnreachablePositionException;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.FixedPositionWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.VariablePositionDefinedWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.VariablePositionWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointNodeConfig;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WaypointNodeConfigApplyer {
    private final URCapToPolyscopeConverter converter;
    private final VariableConverter variableConverter;
    private final InverseKinematicProvider inverseKinematicProvider;

    @Inject
    public WaypointNodeConfigApplyer(URCapToPolyscopeConverter converter, VariableConverter variableConverter, InverseKinematicProvider inverseKinematicProvider) {
        this.converter = converter;
        this.variableConverter = variableConverter;
        this.inverseKinematicProvider = inverseKinematicProvider;
    }

    public void applyConfig(WaypointNodeConfig config, WaypointNode node) {
        switch (config.getConfigType()) {
            case FIXED_POSITION: {
                this.applyFixedPosition((FixedPositionWaypointNodeConfigImpl)config, node);
                break;
            }
            case RELATIVE_POSITION: {
                this.applyRelativePosition((RelativePositionWaypointNodeConfigImpl)config, node);
                break;
            }
            case VARIABLE_POSITION: {
                this.applyVariablePosition((VariablePositionWaypointNodeConfigImpl)config, node);
                break;
            }
            default: {
                throw new IllegalArgumentException("Can't apply configuration for unsupported config type" + config.getConfigType());
            }
        }
    }

    private void applyVariablePosition(VariablePositionWaypointNodeConfigImpl config, WaypointNode node) {
        VariableWaypointNode variableWaypointNode = (VariableWaypointNode)node.convertTo(VariableWaypointNode.class);
        this.applyBlend(node, config.getBlendParameters());
        this.applyMotion(node, config.getMotionParameters());
        variableWaypointNode.setVariable(null);
        if (config.getVariableDefinition() == VariablePositionWaypointNodeConfig.VariableDefinition.DEFINED) {
            VariablePositionDefinedWaypointNodeConfig definedConfig = (VariablePositionDefinedWaypointNodeConfig)config;
            com.ur.urcap.api.domain.variable.Variable urcapVariable = definedConfig.getVariable();
            Variable polyscopeVariable = this.variableConverter.convertToPolyscope((Variable)urcapVariable);
            variableWaypointNode.setVariable(polyscopeVariable);
        }
    }

    private void applyRelativePosition(RelativePositionWaypointNodeConfigImpl config, WaypointNode node) {
        RelativeWaypointNode relativeWaypointNode = (RelativeWaypointNode)node.convertTo(RelativeWaypointNode.class);
        this.applyBlend(node, config.getBlendParameter());
        this.applyMotion(node, config.getWaypointMotionParameters());
        Pose fromPose = config.getFromPose();
        ToolPosition fromToolPosition = this.converter.convertPoseToToolPosition(fromPose);
        JointPositions fromQ = config.getFromQ();
        JointConfiguration fromJointConfiguration = this.converter.convertJointPositionsToJointConfiguration(fromQ);
        Position fromPosition = new Position(fromToolPosition, fromJointConfiguration);
        relativeWaypointNode.setFromPosition(fromPosition);
        Pose toPose = config.getToPose();
        ToolPosition toToolPosition = this.converter.convertPoseToToolPosition(toPose);
        JointPositions toQ = config.getToQ();
        JointConfiguration toJointConfiguration = this.converter.convertJointPositionsToJointConfiguration(toQ);
        Position toPosition = new Position(toToolPosition, toJointConfiguration);
        relativeWaypointNode.setToPosition(toPosition);
    }

    private void applyFixedPosition(FixedPositionWaypointNodeConfig config, WaypointNode node) {
        JointConfiguration jointConfiguration;
        FixedWaypointNode fixedWaypointNode = (FixedWaypointNode)node.convertTo(FixedWaypointNode.class);
        this.applyBlend(node, config.getBlendParameters());
        this.applyMotion(node, config.getMotionParameters());
        FixedPositionWaypointNodeConfig.PositionDefinition positionDefinition = config.getPositionDefinition();
        if (positionDefinition == FixedPositionWaypointNodeConfig.PositionDefinition.UNDEFINED) {
            fixedWaypointNode.setPosition(new Position());
            return;
        }
        FixedPositionDefinedWaypointNodeConfigImpl definedConfig = (FixedPositionDefinedWaypointNodeConfigImpl)config;
        Pose configPose = definedConfig.getPose();
        JointPositions configQNear = definedConfig.getQNear();
        JointPositions configJointPositions = definedConfig.getJointPositionsInternal();
        if (configPose == null || configQNear == null && configJointPositions == null) {
            return;
        }
        ToolPosition toolPosition = this.converter.convertPoseToToolPosition(configPose);
        if (configJointPositions != null) {
            jointConfiguration = this.converter.convertJointPositionsToJointConfiguration(configJointPositions);
        } else {
            JointConfiguration qNear = this.converter.convertJointPositionsToJointConfiguration(configQNear);
            if (!qNear.isDefined()) {
                return;
            }
            Pose definedTcpOffset = definedConfig.getTcpOffset();
            ToolPosition tcpOffset = definedTcpOffset != null ? this.converter.convertPoseToToolPosition(definedTcpOffset) : node.getTCPOffset();
            jointConfiguration = this.inverseKinematicProvider.getInverseKinematics(toolPosition, qNear, tcpOffset);
        }
        if (jointConfiguration == null) {
            throw new UnreachablePositionException("Could not compute joint positions (inverse kinematics failed to find solution)");
        }
        fixedWaypointNode.setPosition(new Position(toolPosition, jointConfiguration));
    }

    private void applyMotion(WaypointNode node, WaypointMotionParameters motionParameters) {
        Motion motion = this.converter.convertWaypointMotionParametersToMotion(motionParameters);
        node.setMotion(motion);
    }

    private void applyBlend(WaypointNode node, BlendParameters blendParameters) {
        Blend blend = this.converter.convertBlendParameterToBlend(blendParameters);
        node.setBlend(blend);
    }
}

