/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.programnodes.waypoint;

import com.ur.monitor.model.JointPositionVector;
import com.ur.polyscope.program.nodes.move.Positional;
import com.ur.polyscope.program.nodes.waypoint.FixedWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.RelativeWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.VariableWaypointNode;
import com.ur.polyscope.program.nodes.waypoint.WaypointNode;
import com.ur.polyscope.program.variables.Variable;
import com.ur.polyscope.program.variables.VariableConverter;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.FixedPositionDefinedWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.FixedPositionWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.PolyscopeToURCapConverter;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.RelativePositionWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.VariablePositionDefinedWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.internal.programnodes.waypoint.VariablePositionWaypointNodeConfigImpl;
import com.ur.polyscope.urcaps.util.OptionalImpl;
import com.ur.polyscope.valueobjects.value.JointConfiguration;
import com.ur.polyscope.valueobjects.value.Position;
import com.ur.polyscope.valueobjects.value.ToolPosition;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.BlendParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.FixedPositionWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.VariablePositionWaypointNodeConfig;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointMotionParameters;
import com.ur.urcap.api.domain.program.nodes.builtin.configurations.waypointnode.WaypointNodeConfig;
import com.ur.urcap.api.domain.value.Pose;
import com.ur.urcap.api.domain.value.jointposition.JointPositions;
import com.ur.urcap.api.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class WaypointNodeConfigExtractor {
    private final PolyscopeToURCapConverter converter;
    private final VariableConverter variableConverter;

    @Inject
    public WaypointNodeConfigExtractor(PolyscopeToURCapConverter polyscopeToURCapConverter, VariableConverter variableConverter) {
        this.converter = polyscopeToURCapConverter;
        this.variableConverter = variableConverter;
    }

    public WaypointNodeConfig extractConfig(WaypointNode node) {
        Object config;
        Class type = node.getType();
        if (type == FixedWaypointNode.class) {
            config = this.extractFixedPositionConfig((FixedWaypointNode)node.convertTo(FixedWaypointNode.class));
        } else if (type == RelativeWaypointNode.class) {
            config = this.extractRelativeConfig((RelativeWaypointNode)node.convertTo(RelativeWaypointNode.class));
        } else if (type == VariableWaypointNode.class) {
            config = this.extractVariablePositionConfig((VariableWaypointNode)node.convertTo(VariableWaypointNode.class));
        } else {
            throw new IllegalArgumentException("Can't get config for unsupported node type " + type);
        }
        return config;
    }

    public FixedPositionWaypointNodeConfig extractFixedPositionConfig(FixedWaypointNode node) {
        FixedPositionWaypointNodeConfigImpl config;
        Position position = node.getPosition();
        ToolPosition toolPosition = position.getToolPosition();
        JointConfiguration jointConfiguration = position.getJointConfiguration();
        BlendParameters blend = this.converter.convertBlendToBlendParameters(node.getBlend());
        WaypointMotionParameters motion = this.converter.convertMotionToWaypointMotionParameters(node.getMotion());
        if (toolPosition == null || !jointConfiguration.isDefined()) {
            config = new FixedPositionWaypointNodeConfigImpl(blend, motion);
        } else {
            Pose pose = this.converter.convertToolPositionToPose(toolPosition);
            JointPositions jointPositions = this.converter.convertJointConfigurationToJointPositions(jointConfiguration);
            Optional<JointPositions> actualJointPositions = this.extractActualJointPositions(node);
            config = new FixedPositionDefinedWaypointNodeConfigImpl(pose, jointPositions, blend, motion, actualJointPositions);
        }
        return config;
    }

    private Optional<JointPositions> extractActualJointPositions(FixedWaypointNode node) {
        Positional positionalNode;
        JointPositionVector actualPosition;
        double[] actualJoints;
        JointConfiguration actualJointConfiguration;
        JointPositions pos;
        if (node instanceof Positional && (pos = this.converter.convertJointConfigurationToJointPositions(actualJointConfiguration = new JointConfiguration(actualJoints = (actualPosition = (positionalNode = (Positional)node).getActualJointPositionVector()).getJoints()))) != null) {
            return OptionalImpl.of((Object)pos);
        }
        return OptionalImpl.empty();
    }

    private RelativePositionWaypointNodeConfigImpl extractRelativeConfig(RelativeWaypointNode node) {
        Position fromPosition = node.getFromPosition();
        Position toPosition = node.getToPosition();
        Pose fromPose = this.converter.convertToolPositionToPose(fromPosition.getToolPosition());
        JointPositions fromQ = this.converter.convertJointConfigurationToJointPositions(fromPosition.getJointConfiguration());
        Pose toPose = this.converter.convertToolPositionToPose(toPosition.getToolPosition());
        JointPositions toQ = this.converter.convertJointConfigurationToJointPositions(toPosition.getJointConfiguration());
        BlendParameters blendParameter = this.converter.convertBlendToBlendParameters(node.getBlend());
        WaypointMotionParameters waypointMotionParameters = this.converter.convertMotionToWaypointMotionParameters(node.getMotion());
        RelativePositionWaypointNodeConfigImpl config = new RelativePositionWaypointNodeConfigImpl(fromPose, fromQ, toPose, toQ, blendParameter, waypointMotionParameters);
        return config;
    }

    public VariablePositionWaypointNodeConfig extractVariablePositionConfig(VariableWaypointNode node) {
        VariablePositionWaypointNodeConfigImpl waypointNodeConfig;
        BlendParameters blend = this.converter.convertBlendToBlendParameters(node.getBlend());
        WaypointMotionParameters motion = this.converter.convertMotionToWaypointMotionParameters(node.getMotion());
        Variable internalVariable = node.getVariable();
        if (internalVariable == null) {
            waypointNodeConfig = new VariablePositionWaypointNodeConfigImpl(blend, motion);
        } else {
            com.ur.urcap.api.domain.variable.Variable variable = (com.ur.urcap.api.domain.variable.Variable)this.variableConverter.convertToURCap(internalVariable);
            waypointNodeConfig = new VariablePositionDefinedWaypointNodeConfigImpl(variable, blend, motion);
        }
        return waypointNodeConfig;
    }
}

