/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.internal.validation;

import com.ur.polyscope.urcaps.internal.validation.AbstractUnitValidator;
import com.ur.polyscope.valueobjects.validation.Validator;
import com.ur.urcap.api.domain.value.blend.Blend;
import com.ur.urcap.api.domain.value.blend.BlendFactory;
import com.ur.urcap.api.domain.value.simple.Length;
import com.ur.urcap.api.domain.value.simple.SimpleValueFactory;

public class RadiusBlendInMValidator
extends AbstractUnitValidator<Blend, Double> {
    private SimpleValueFactory simpleValueFactory;
    private BlendFactory blendFactory;

    public RadiusBlendInMValidator(SimpleValueFactory simpleValueFactory, BlendFactory blendFactory, Validator<Double> validator) {
        super(validator);
        this.simpleValueFactory = simpleValueFactory;
        this.blendFactory = blendFactory;
    }

    @Override
    protected Double asValidatorValue(Blend value) {
        return value.getRadiusLength().getAs(Length.Unit.M);
    }

    @Override
    protected Blend asUnitValue(Double value) {
        Length length = this.simpleValueFactory.createLength(value.doubleValue(), Length.Unit.M);
        return this.blendFactory.createBlend(length);
    }
}

