/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.urcaps.version;

import com.ur.lang.Defense;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Singleton;
import org.osgi.framework.Version;

@Singleton
public class URCapAPIPackageRepository {
    private Map<Version, HashMap<String, Version>> apiPackageRepository = new TreeMap<Version, HashMap<String, Version>>();

    public void addPackageInfoToRepository(String apiVersionText, String packageName, String packageVersion) {
        Version apiVersion = new Version(apiVersionText);
        HashMap<String, Object> packageInfoMap = this.apiPackageRepository.get(apiVersion);
        if (packageInfoMap == null) {
            packageInfoMap = new HashMap();
            this.apiPackageRepository.put(apiVersion, packageInfoMap);
        }
        packageInfoMap.put(packageName, new Version(packageVersion));
    }

    public VersionInfo getAPIVersionForPackageString(String packageString) {
        String[] splited;
        if (this.apiPackageRepository == null || this.apiPackageRepository.isEmpty()) {
            return new VersionInfo(null, LOOKUP_STATUS.API_REPO_UNAVAILABLE);
        }
        HashMap<String, String> packageInfoMap = new HashMap<String, String>();
        String[] stringArray = splited = packageString.replace(" ", "").split("\",");
        int n = splited.length;
        int n2 = 0;
        while (n2 < n) {
            String packageImport = stringArray[n2];
            String[] packageImportLineSplit = packageImport.replace("\"", "").split(";");
            if (packageImportLineSplit.length > 1) {
                String versionRangeText = this.extractVersionRange(packageImportLineSplit);
                if (this.ifURCapInternalPackage(packageImportLineSplit[0]) && !versionRangeText.isEmpty()) {
                    packageInfoMap.put(packageImportLineSplit[0], versionRangeText);
                }
            }
            ++n2;
        }
        if (packageInfoMap.isEmpty()) {
            return new VersionInfo(null, LOOKUP_STATUS.NO_PACKAGE_IMPORTS_FOUND);
        }
        return this.getAPIVersionForPackageSet(packageInfoMap);
    }

    public VersionInfo getAPIVersionForPackageSet(Map<String, String> requiredPackages) {
        if (this.apiPackageRepository == null || this.apiPackageRepository.isEmpty()) {
            return new VersionInfo(null, LOOKUP_STATUS.API_REPO_UNAVAILABLE);
        }
        for (Object versionKey : ((TreeMap)this.apiPackageRepository).descendingKeySet()) {
            Version version = (Version)versionKey;
            HashMap<String, Version> providedPackages = this.apiPackageRepository.get(versionKey);
            if (!this.areAllPackagesBeingProvided(providedPackages, requiredPackages)) continue;
            return new VersionInfo(version.toString(), LOOKUP_STATUS.VERSION_MATCH_FOUND);
        }
        return new VersionInfo(null, LOOKUP_STATUS.NO_VERSION_MATCH_FOUND);
    }

    public String getlatestAPIVersionAvailable() {
        if (this.apiPackageRepository.isEmpty()) {
            return null;
        }
        Version highestVersion = (Version)((TreeMap)this.apiPackageRepository).lastKey();
        return highestVersion != null ? highestVersion.toString() : null;
    }

    private boolean ifURCapInternalPackage(String packageName) {
        return packageName.startsWith("com.ur;") || packageName.equals("com.ur") || packageName.startsWith("com.ur.");
    }

    private String extractVersionRange(String[] lines) {
        String version = "";
        int j = 1;
        while (j < lines.length) {
            if (lines[j].startsWith("version=")) {
                version = lines[j].substring("version=".length());
                break;
            }
            ++j;
        }
        return version.trim();
    }

    private boolean areAllPackagesBeingProvided(Map<String, Version> providedPackages, Map<String, String> requiredPackages) {
        Defense.notNull(providedPackages);
        for (Map.Entry<String, String> requiredPackage : requiredPackages.entrySet()) {
            String requiredPackageName = requiredPackage.getKey();
            Version vToSearchFor = this.extractVersionText(requiredPackages.get(requiredPackageName));
            if (providedPackages.containsKey(requiredPackageName) && this.ifVersionMatches(providedPackages.get(requiredPackageName), vToSearchFor)) continue;
            return false;
        }
        return true;
    }

    private boolean ifVersionMatches(Version version, Version vToSearchFor) {
        return version.equals((Object)vToSearchFor) || version.getMajor() == vToSearchFor.getMajor() && version.getMinor() == vToSearchFor.getMinor();
    }

    private Version extractVersionText(String versionText) {
        if (this.isDefinedAsRange(versionText)) {
            String[] versionInfo = versionText.substring(1, versionText.length() - 1).split(",");
            if (versionText.startsWith("(")) {
                return this.getNextMinorVersion(versionInfo[0]);
            }
            return new Version(versionInfo[0]);
        }
        return new Version(versionText);
    }

    private Version getNextMinorVersion(String version) {
        Version versionObj = new Version(version);
        return new Version(versionObj.getMajor(), versionObj.getMinor() + 1, 0);
    }

    private boolean isDefinedAsRange(String text) {
        return !text.isEmpty() && this.isEnclosedByBrackets(text) && text.contains(",");
    }

    private boolean isEnclosedByBrackets(String text) {
        return !(!text.startsWith("[") && !text.startsWith("(") || !text.endsWith("]") && !text.endsWith(")"));
    }

    public static enum LOOKUP_STATUS {
        VERSION_MATCH_FOUND,
        NO_VERSION_MATCH_FOUND,
        NO_PACKAGE_IMPORTS_FOUND,
        API_REPO_UNAVAILABLE;

    }

    public static class VersionInfo {
        String version;
        LOOKUP_STATUS status;

        public VersionInfo(String v, LOOKUP_STATUS status) {
            this.version = v;
            this.status = status;
        }

        public boolean isVersionAvailable() {
            return this.version != null && !this.version.isEmpty();
        }

        public LOOKUP_STATUS getStatus() {
            return this.status;
        }

        public String getVersion() {
            return this.version;
        }
    }
}

