/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.filemanager;

import com.ur.polyscope.filemanager.URFileFilter;
import java.io.File;

public class FileManagerConfiguration {
    private final String title;
    private final Access restricted;
    private final File directory;
    private final URFileFilter[] filters;
    private final boolean isDirectoryEndpoint;

    public FileManagerConfiguration(String title, Access restricted, File programs, URFileFilter ... filters) {
        this(title, restricted, programs, false, filters);
    }

    public FileManagerConfiguration(String title, Access restricted, File programs, boolean isDirectoryEndpoint, URFileFilter ... filters) {
        this.title = title;
        this.restricted = restricted;
        this.directory = programs;
        this.filters = (URFileFilter[])filters.clone();
        this.isDirectoryEndpoint = isDirectoryEndpoint;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean isRestrictedAccess() {
        return this.restricted == Access.RESTRICTED;
    }

    public File directory() {
        return this.directory;
    }

    public URFileFilter[] fileFilters() {
        return (URFileFilter[])this.filters.clone();
    }

    public boolean isDirectoryEndpoint() {
        return this.isDirectoryEndpoint;
    }

    public static enum Access {
        RESTRICTED,
        UNRESTRICTED;

    }
}

