/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.toolbar.impl;

import com.ur.polyscope.toolbar.impl.SoftShadowBorder;
import com.ur.polyscope.toolbar.impl.header.TabbedToolbarView;
import com.ur.polyscope.toolbar.internal.ImageResource;
import com.ur.swing.ActionDefinition;
import com.ur.swing.JFrameUtils;
import com.ur.swing.SwingUtil;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.logging.Log;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class ToolbarGlassPanelOverlayAction
extends MenuExtension.AbstractOverlayAction {
    public static final int SCREEN_WIDTH = 1280;
    public static final int SCREEN_HEIGHT = 800;
    public static final int POLYSCOPE_HEADER_HEIGHT = 64;
    public static final int POLYSCOPE_FOOTER_HEIGHT = 63;
    public static final int TOOLBAR_FULL_WIDTH = 545;
    public static final int TOOLBAR_FULL_HEIGHT = 673;
    public static final String OPEN_TOOLBAR = "urcapToolbar.ToolbarGlassPanelOverlayAction";
    private final TabbedToolbarView toolbarPanel;
    private JPanel onGlassPane;

    @Inject
    protected ToolbarGlassPanelOverlayAction(TabbedToolbarView toolbarPanel) {
        this.toolbarPanel = toolbarPanel;
        this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        this.putValue("SmallIcon", ImageResource.urPlusLogo());
        this.putValue("InternalName", OPEN_TOOLBAR);
        toolbarPanel.setBorder(SoftShadowBorder.create());
        this.setEnabled(toolbarPanel.hasContributions());
    }

    public void actionPerformed(ActionEvent e) {
        if (this.onGlassPane == null) {
            this.onGlassPane = new JPanel(new FlowLayout(1, 0, 0));
            this.onGlassPane.setOpaque(false);
            this.onGlassPane.setLocation(735, 64);
            this.onGlassPane.setSize(545, 673);
            this.onGlassPane.add(this.toolbarPanel);
            this.getApplicationLayeredPane().add(this.onGlassPane);
            Log.info((String)"Create and show toolbar");
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToolbarGlassPanelOverlayAction.this.onGlassPane.repaint();
                    ToolbarGlassPanelOverlayAction.this.toolbarPanel.setVisible(true);
                }
            });
            this.notifyOverlayEnabled(true);
        } else if (this.onGlassPane.isVisible()) {
            this.onGlassPane.setVisible(false);
            this.toolbarPanel.setVisible(false);
            this.notifyOverlayEnabled(false);
            Log.info((String)"Hide toolbar");
        } else {
            this.onGlassPane.setVisible(true);
            this.toolbarPanel.setVisible(true);
            this.notifyOverlayEnabled(true);
            Log.info((String)"Show toolbar");
        }
    }

    protected JComponent getApplicationLayeredPane() {
        JFrame frame = (JFrame)JFrameUtils.getApplicationFrame().get();
        return frame.getLayeredPane();
    }

    public boolean isRestrictive() {
        return true;
    }

    public void setEnabled(boolean newValue) {
        if (this.toolbarPanel != null) {
            super.setEnabled(this.toolbarPanel.hasContributions() && newValue);
        } else {
            super.setEnabled(false);
        }
    }
}

