/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.toolbar.impl;

import com.ur.polyscope.toolbar.impl.header.Tab;
import com.ur.polyscope.toolbar.impl.header.TabbedToolbarView;
import com.ur.polyscope.urcaps.ExceptionLogger;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.urcap.api.contribution.toolbar.ToolbarContext;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import com.ur.util.logging.Log;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Provider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class URCapToolbarContributionsWeaver {
    private TabbedToolbarView panel;
    private final ToolbarContext context;
    private final Provider<URCapErrorHandler> urCapErrorHandlerProvider;
    private final BundleClassAuthorizer authorizer;
    private final Provider<ExceptionLogger> exceptionLoggerProvider;
    private List<SwingToolbarService> toolbarContributionServices = new ArrayList<SwingToolbarService>();

    @Inject
    public URCapToolbarContributionsWeaver(TabbedToolbarView panel, ToolbarContext context, Provider<URCapErrorHandler> urCapErrorHandlerProvider, BundleClassAuthorizer authorizer, Provider<ExceptionLogger> exceptionLoggerProvider) {
        this.panel = panel;
        this.context = context;
        this.urCapErrorHandlerProvider = urCapErrorHandlerProvider;
        this.exceptionLoggerProvider = exceptionLoggerProvider;
        this.authorizer = authorizer;
    }

    public void init(BundleContext bundleContext) {
        try {
            for (ServiceReference ref : bundleContext.getServiceReferences(SwingToolbarService.class, null)) {
                SwingToolbarService service = (SwingToolbarService)bundleContext.getService(ref);
                this.addToolbarContributionService(service);
            }
            this.panel.initTabs(this.convertToTabs(this.toolbarContributionServices));
        }
        catch (InvalidSyntaxException e) {
            Log.error((String)"Unexpected OSGi error", (Throwable)e);
        }
    }

    private Iterable<Tab> convertToTabs(List<SwingToolbarService> toolbarContributionServices) {
        ArrayList<Tab> result = new ArrayList<Tab>();
        for (SwingToolbarService each : toolbarContributionServices) {
            result.add(this.createTab(each));
        }
        return result;
    }

    protected Tab createTab(SwingToolbarService each) {
        return new Tab(each, this.context, (URCapErrorHandler)this.urCapErrorHandlerProvider.get(), this.authorizer, (ExceptionLogger)this.exceptionLoggerProvider.get());
    }

    public List<SwingToolbarService> addToolbarContributionService(SwingToolbarService swingToolbarService) {
        this.toolbarContributionServices.add(swingToolbarService);
        return new ArrayList<SwingToolbarService>(this.toolbarContributionServices);
    }

    public List<SwingToolbarService> removeToolbarContributionService(SwingToolbarService swingToolbarService) {
        this.toolbarContributionServices.remove(swingToolbarService);
        return new ArrayList<SwingToolbarService>(this.toolbarContributionServices);
    }
}

