/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.toolbar.impl.header;

import com.ur.lang.Defense;
import com.ur.polyscope.toolbar.impl.header.ConfigurationImpl;
import com.ur.polyscope.toolbar.impl.header.TabPanel;
import com.ur.polyscope.urcaps.ExceptionLogger;
import com.ur.polyscope.urcaps.ToolbarContributionVisibilityEvent;
import com.ur.polyscope.urcaps.URCapErrorHandler;
import com.ur.polyscope.urcaps.URCapErrorPanel;
import com.ur.polyscope.urcaps.nodeservices.ProxiedService;
import com.ur.swing.BundleClassAuthorizer;
import com.ur.swing.BundleClassAuthorizerImpl;
import com.ur.swing.RestrictedPanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.api.contribution.toolbar.ToolbarConfiguration;
import com.ur.urcap.api.contribution.toolbar.ToolbarContext;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarContribution;
import com.ur.urcap.api.contribution.toolbar.swing.SwingToolbarService;
import com.ur.util.event.EventNotificationService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class Tab
extends JLabel {
    public static final int MAX_TOOLBAR_CONTENT_HEIGHT = 604;
    private final UUID uniqueId = UUID.randomUUID();
    private final ConfigurationImpl configuration = new ConfigurationImpl();
    private final URCapErrorHandler urCapErrorHandler;
    private final BundleClassAuthorizer authorizer;
    private final ExceptionLogger exceptionLogger;
    private final JPanel panel = new JPanel(new BorderLayout(0, 0));
    private SwingToolbarContribution contribution;

    Tab(Icon icon) {
        super(icon, 0);
        this.urCapErrorHandler = new URCapErrorHandlerStub();
        this.exceptionLogger = (throwable, stackTraceElement, aClass) -> {};
        this.authorizer = new BundleClassAuthorizerImpl();
    }

    public Tab(SwingToolbarService service, ToolbarContext context, URCapErrorHandler urCapErrorHandler, BundleClassAuthorizer authorizer, ExceptionLogger exceptionLogger) {
        this.urCapErrorHandler = urCapErrorHandler;
        this.exceptionLogger = exceptionLogger;
        this.authorizer = authorizer;
        Class serviceClass = service instanceof ProxiedService ? ((ProxiedService)service).getProxiedService() : service.getClass();
        urCapErrorHandler.getErrorPanel().setMetadataFromClass(serviceClass);
        try {
            Icon icon = service.getIcon();
            Defense.isCondition((icon.getIconWidth() <= 89 ? 1 : 0) != 0, (String)"Icon is too wide, must be 89 pixels or less");
            Defense.isCondition((icon.getIconHeight() <= 30 ? 1 : 0) != 0, (String)"Icon is too high, must be 30 pixels or less");
            this.setIcon(icon);
            service.configureContribution((ToolbarConfiguration)this.configuration);
            this.configuration.lock();
            this.contribution = service.createToolbar(context);
        }
        catch (AssertionError e) {
            urCapErrorHandler.handle((Throwable)((Object)e));
            this.replaceContentWithError();
        }
        catch (RuntimeException e) {
            this.handleException(e, this.contribution.getClass());
        }
        this.setHorizontalAlignment(0);
        this.setBorder(BorderFactory.createEmptyBorder(15, 15, 15, 15));
        this.setOpaque(true);
        this.panel.setOpaque(true);
        if (this.contribution != null) {
            this.setName("tab." + this.contribution.getClass().getName());
        }
        this.unselect();
    }

    public void addActionListener(final ActionListener listener) {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                listener.actionPerformed(null);
            }
        });
    }

    public void unselect() {
        this.setBackground(TabPanel.SOFT_GRAY);
    }

    public void select() {
        this.setBackground(G5LookAndFeel.UNIVERSAL_ROBOTS_BLUE);
    }

    public String getId() {
        return this.uniqueId.toString();
    }

    public JPanel getPanel() {
        if (this.panel.getComponentCount() == 0 && !this.urCapErrorHandler.hasError()) {
            try {
                RestrictedPanel restrictedPanel = this.createRestrictedPanel(this.configuration.getToolbarHeight());
                this.contribution.buildUI((JPanel)restrictedPanel);
                this.panel.add((Component)restrictedPanel, 0);
                this.panel.setPreferredSize(restrictedPanel.getPreferredSize());
            }
            catch (RuntimeException e) {
                this.handleException(e, this.contribution.getClass());
            }
        }
        return this.panel;
    }

    private RestrictedPanel createRestrictedPanel(int height) {
        return new RestrictedPanel(new Dimension(540, height), BorderFactory.createEmptyBorder(5, 5, 5, 5), this.authorizer);
    }

    private void replaceContentWithError() {
        URCapErrorPanel errorPanel = this.urCapErrorHandler.getErrorPanel();
        this.panel.removeAll();
        this.panel.add((Component)errorPanel, 0);
        this.panel.setPreferredSize(new Dimension(540, 604));
    }

    public void openView() {
        if (!this.urCapErrorHandler.hasError()) {
            try {
                this.contribution.openView();
                this.notifyUrCapToolbarContributionIsVisible();
            }
            catch (RuntimeException e) {
                this.handleException(e, this.contribution.getClass());
            }
        }
    }

    public void closeView() {
        if (!this.urCapErrorHandler.hasError()) {
            try {
                this.contribution.closeView();
                this.notifyUrCapToolbarContributionIsInvisible();
            }
            catch (RuntimeException e) {
                this.handleException(e, this.contribution.getClass());
            }
        }
    }

    private void notifyUrCapToolbarContributionIsVisible() {
        EventNotificationService.notify(ToolbarContributionVisibilityEvent.class, listener -> listener.contributionIsVisible(this.uniqueId));
    }

    private void notifyUrCapToolbarContributionIsInvisible() {
        EventNotificationService.notify(ToolbarContributionVisibilityEvent.class, listener -> listener.contributionIsInvisible(this.uniqueId));
    }

    private void handleException(Throwable e, Class<? extends SwingToolbarContribution> contributionClass) {
        this.urCapErrorHandler.handle(e);
        this.exceptionLogger.log(e, e.getStackTrace()[1], contributionClass);
        this.replaceContentWithError();
    }

    public static class URCapErrorPanelStub
    extends URCapErrorPanel {
        public void setMetadataFromClass(Class clazz) {
        }

        public void setStackTrace(String stackTrace) {
        }
    }

    public static class URCapErrorHandlerStub
    implements URCapErrorHandler {
        public URCapErrorPanel getErrorPanel() {
            return new URCapErrorPanelStub();
        }

        public void handle(Throwable e) {
        }

        public boolean hasError() {
            return false;
        }

        public void clearError() {
        }
    }
}

