/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.toolbar.impl.header;

import com.ur.polyscope.toolbar.impl.header.Tab;
import com.ur.polyscope.toolbar.internal.ImageResource;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class TabPanel
extends JPanel {
    public static final int TAB_PANEL_WIDTH = 540;
    public static final int TAB_PANEL_HEIGHT = 64;
    public static final String RIGHT_SCROLL = "rightScroll." + TabPanel.class.getName();
    public static final String LEFT_SCROLL = "leftScroll." + TabPanel.class.getName();
    static final Color SOFT_GRAY = new Color(230, 230, 230);
    private final Scroll rightScrollButton;
    private final Scroll leftScrollButton;
    private ArrayList<Tab> allTabs;
    private int activeIndex = 0;
    private JPanel[] indexOfTabs = new JPanel[10];
    private Tab selected = null;

    TabPanel() {
        this.setSize(540, 64);
        this.setPreferredSize(new Dimension(540, 64));
        this.setLayout(new BorderLayout(0, 0));
        this.setBackground(SOFT_GRAY);
        this.allTabs = new ArrayList();
        for (int i = 0; i < this.indexOfTabs.length; ++i) {
            this.indexOfTabs[i] = new JPanel(new GridLayout());
            this.indexOfTabs[i].setOpaque(false);
        }
        this.add((Component)this.indexOfTabs[0], "Center");
        this.rightScrollButton = new Scroll(ImageResource.arrowRight());
        this.rightScrollButton.setName(RIGHT_SCROLL);
        this.rightScrollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanel.this.activeIndex = TabPanel.this.scroll(TabPanel.this.activeIndex + 1, TabPanel.this.activeIndex);
            }
        });
        this.leftScrollButton = new Scroll(ImageResource.arrowLeft());
        this.leftScrollButton.setName(LEFT_SCROLL);
        this.leftScrollButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TabPanel.this.activeIndex = TabPanel.this.scroll(TabPanel.this.activeIndex - 1, TabPanel.this.activeIndex);
            }
        });
    }

    public void addTab(final Tab tab) {
        tab.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TabPanel.this.selected.unselect();
                tab.select();
                TabPanel.this.selected = tab;
            }
        });
        if (this.selected == null) {
            this.selected = tab;
            this.selected.select();
        }
        this.indexOfTabs[this.allTabs.size() / 4].add(tab);
        this.allTabs.add(tab);
        if (this.allTabs.size() > 4) {
            this.add((Component)this.rightScrollButton, "East");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int scroll(int desired, int active) {
        this.setVisible(false);
        try {
            boolean rightPaneHasChildren;
            boolean isFarLeft;
            this.remove(this.indexOfTabs[active]);
            this.add((Component)this.indexOfTabs[desired], "Center");
            boolean bl = isFarLeft = desired == 0;
            if (isFarLeft) {
                this.remove(this.leftScrollButton);
            } else {
                this.add((Component)this.leftScrollButton, "West");
            }
            boolean bl2 = rightPaneHasChildren = desired < this.indexOfTabs.length && this.indexOfTabs[desired + 1].getComponentCount() > 0;
            if (rightPaneHasChildren) {
                this.add((Component)this.rightScrollButton, "East");
            } else {
                this.remove(this.rightScrollButton);
            }
        }
        finally {
            this.setVisible(true);
        }
        return desired;
    }

    public Tab getSelectedTab() {
        return this.selected;
    }

    private static class Scroll
    extends JButton {
        Scroll(Icon imageIcon) {
            super(imageIcon);
            this.setBackground(SOFT_GRAY);
            this.setOpaque(true);
            this.setFocusable(false);
            this.setBorder(BorderFactory.createEmptyBorder(15, 25, 15, 25));
        }
    }
}

