/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.toolbar.impl.header;

import com.ur.polyscope.toolbar.impl.header.SelectedTab;
import com.ur.polyscope.toolbar.impl.header.Tab;
import com.ur.polyscope.toolbar.impl.header.TabPanel;
import com.ur.swing.g5.G5LookAndFeel;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.inject.Singleton;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

@Singleton
public class TabbedToolbarView
extends JPanel {
    public static final int LEFT_BORDER_WIDTH = 5;
    public static final int BOTTOM_BORDER_HEIGHT = 5;
    private static final String URCAP_TOOLBAR_TABS = "tabs." + TabbedToolbarView.class.getSimpleName();
    private final SelectedTab selectedTab;
    private Iterable<Tab> tabs;

    public TabbedToolbarView() {
        super(new BorderLayout(0, 0));
        this.setName(URCAP_TOOLBAR_TABS);
        this.setBorder(BorderFactory.createMatteBorder(0, 5, 5, 0, G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE));
        this.setOpaque(false);
        this.selectedTab = new SelectedTab();
    }

    static void flipToCard(JPanel panel, String cardName) {
        CardLayout layout = (CardLayout)panel.getLayout();
        layout.show(panel, cardName);
    }

    @Override
    public void setVisible(boolean aFlag) {
        super.setVisible(aFlag);
        if (aFlag) {
            this.selectedTab.openView();
            this.updateSize();
        } else {
            this.selectedTab.closeView();
        }
    }

    public void initTabs(Iterable<Tab> tabs) {
        this.tabs = tabs;
        TabPanel tabHeader = new TabPanel();
        JPanel toolbarPanel = new JPanel(new CardLayout());
        toolbarPanel.setOpaque(false);
        if (tabs.iterator().hasNext()) {
            this.selectedTab.set(tabs.iterator().next());
        }
        for (Tab each : tabs) {
            each.addActionListener(new FlipToTab(this, toolbarPanel, each, this.selectedTab));
            tabHeader.addTab(each);
            toolbarPanel.add((Component)each.getPanel(), each.getId());
        }
        this.addMouseListener(this.createEmptyMouseAdapter());
        this.add((Component)tabHeader, "North");
        this.add((Component)toolbarPanel, "Center");
    }

    private MouseAdapter createEmptyMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
    }

    public boolean hasContributions() {
        return this.tabs != null && this.tabs.iterator().hasNext();
    }

    private void updateSize() {
        JPanel panel = this.selectedTab.getSelected().getPanel();
        Dimension panelSize = panel.getPreferredSize();
        Dimension preferredSize = new Dimension(545, 69 + panelSize.height);
        this.setPreferredSize(preferredSize);
        Container onGlassPanel = this.getParent();
        onGlassPanel.setSize(preferredSize);
        onGlassPanel.invalidate();
    }

    private static class FlipToTab
    implements ActionListener {
        private final TabbedToolbarView view;
        private final JPanel toolbarPanel;
        private final Tab tab;
        private final SelectedTab selectedTab;

        FlipToTab(TabbedToolbarView view, JPanel toolbarPanel, Tab each, SelectedTab selectedTab) {
            this.view = view;
            this.toolbarPanel = toolbarPanel;
            this.tab = each;
            this.selectedTab = selectedTab;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedToolbarView.flipToCard(this.toolbarPanel, this.tab.getId());
            this.selectedTab.setSelected(this.tab);
            this.view.updateSize();
        }
    }
}

