/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.platform.api;

import com.ur.polyscope.platform.api.PlatformType;
import com.ur.polyscope.platform.api.SoftwarePlatformType;
import com.ur.util.commandline.BashScriptRunner;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class PlatformEnvironment {
    private static final String USER = System.getenv("USER") == null ? "dummy" : System.getenv("USER");

    public static PlatformType getPlatFormType() {
        if (PlatformEnvironment.isOnURSimVM()) {
            return PlatformType.URSIM;
        }
        if (PlatformEnvironment.isIntegrationTest()) {
            return PlatformType.INTEGRATIONTEST;
        }
        if (PlatformEnvironment.isURDocker()) {
            return PlatformType.URDOCKER;
        }
        if (PlatformEnvironment.isOnRobot()) {
            return PlatformType.ROBOT;
        }
        return PlatformType.DEVELOPER;
    }

    public static SoftwarePlatformType getSoftwarePlatFormType() {
        return SoftwarePlatformType.SW5;
    }

    private static boolean isIntegrationTest() {
        String env = System.getProperty("itEnv");
        return "local".equals(env);
    }

    private static boolean isOnURSimVM() {
        String hostname = null;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            Log.warning((String)("Could not determine if running in URSim - Unable to resolve hostname. " + e.getMessage()));
        }
        return "ursim".equals(hostname);
    }

    private static boolean isURDocker() {
        return "docker".equals(USER) || PlatformEnvironment.runScript("cat /proc/1/cgroup").contains("docker");
    }

    private static boolean isOnRobot() {
        return "kiosk".equals(USER) || "root".equals(USER);
    }

    private static String runScript(String script) {
        BashScriptRunner runner = new BashScriptRunner(script, null, null);
        try {
            runner.execute();
        }
        catch (IOException e) {
            Log.warning((String)"Could not execute script", (Throwable)e);
        }
        return runner.getOutputString();
    }
}

