/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.InputProcessor;
import com.ur.polyscope.dashboardserver.impl.DashboardServerConnectionCreatorThread;
import com.ur.polyscope.dashboardserver.impl.NotifyOnPolyScopeStarted;
import com.ur.polyscope.dashboardserver.impl.StandardInputProcessor;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.net.ServerSocket;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class DashBoardServer {
    public static final int RW_SOCKET_PORT = 29999;
    private ServerSocket serverSocket;
    private DashboardServerConnectionCreatorThread connectionCreatorThread;

    @Inject
    private DashBoardServer(NotifyOnPolyScopeStarted notifyOnPolyScopeStarted, StandardInputProcessor processor) {
        this(29999, notifyOnPolyScopeStarted, processor);
    }

    protected DashBoardServer(int port, NotifyOnPolyScopeStarted notifyOnPolyScopeStarted, InputProcessor processor) {
        try {
            this.serverSocket = new ServerSocket(port);
            this.connectionCreatorThread = new DashboardServerConnectionCreatorThread(this.serverSocket, notifyOnPolyScopeStarted, processor);
            this.connectionCreatorThread.start();
        }
        catch (Exception e) {
            if (e.getMessage().contains("Address already in use")) {
                Log.error((String)"Address already in use 29999: ");
            }
            Log.error((String)"Could not instantiate ServerSocket on port 29999: ", (Throwable)e);
        }
    }

    public int getTestSocketPort() {
        return this.serverSocket.getLocalPort();
    }

    public void stop() throws IOException {
        this.connectionCreatorThread.stopThread();
    }
}

