/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.polyscope.dashboardserver.impl.DashboardActionTask;
import com.ur.polyscope.dashboardserver.impl.DashboardClient;
import com.ur.util.logging.Log;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;

class DashboardActionTaskRejectedExecutionHandler
implements RejectedExecutionHandler {
    private final DashboardClient dashboardClient;
    private boolean logged;

    public DashboardActionTaskRejectedExecutionHandler(DashboardClient dashboardClient) {
        this.dashboardClient = dashboardClient;
    }

    @Override
    public void rejectedExecution(Runnable dashboardCommand, ThreadPoolExecutor executor) {
        this.logRejected();
        String command = ((DashboardActionTask)dashboardCommand).getAction();
        String output = "Dashboard command '" + command + "' was rejected. Maximum queue size of " + 100000 + " exceeded";
        this.dashboardClient.rejectionToOutputQueue(output);
    }

    private void logRejected() {
        if (!this.logged) {
            Log.warning((String)"Dashboard server input queue is full. New actions will be rejected until queue is below 100000 This warning will not be logged again for this connection");
            this.logged = true;
        }
    }
}

