/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.InputProcessor;
import com.ur.polyscope.dashboardserver.impl.DashboardActionTask;
import com.ur.polyscope.dashboardserver.impl.DashboardActionTaskRejectedExecutionHandler;
import com.ur.polyscope.dashboardserver.impl.Statistics;
import com.ur.util.logging.Log;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class DashboardClient
extends Thread {
    protected static final String DASHBOARD_CLIENT_THREAD = "DashboardClientThread_";
    public static final String DISCONNECTED = "Disconnected";
    protected static final int CAPACITY = 100000;
    private static final String WELCOME_GREETING = "Connected: Universal Robots Dashboard Server";
    private final Socket clientSocket;
    private final ExecutorService inputExecuterService;
    private final ExecutorService outputExecuterService;
    private final BufferedReader clientInput;
    private final PrintWriter clientOutput;
    private final InputProcessor processor;
    private boolean isShutdown;
    private boolean gracefulClosed;
    private final Statistics statistics;

    DashboardClient(Socket clientSocket, InputProcessor processor, Statistics statistics) throws IOException {
        super(DASHBOARD_CLIENT_THREAD + System.currentTimeMillis());
        this.clientSocket = clientSocket;
        this.clientOutput = new PrintWriter(clientSocket.getOutputStream(), true);
        this.clientInput = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
        this.processor = processor;
        this.statistics = statistics;
        this.inputExecuterService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100000), Executors.defaultThreadFactory(), new DashboardActionTaskRejectedExecutionHandler(this));
        this.outputExecuterService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), Executors.defaultThreadFactory(), new ThreadPoolExecutor.DiscardPolicy());
        this.writeToOutputDirectly(WELCOME_GREETING);
    }

    public DashboardClient(Socket clientSocket, InputProcessor processor) throws IOException {
        this(clientSocket, processor, new Statistics());
    }

    @Override
    public void run() {
        try {
            String command;
            while ((command = this.clientInput.readLine()) != null) {
                this.statistics.actionsReceived();
                this.inputExecuterService.execute(new DashboardActionTask(command, this.processor, this));
            }
            Log.info((String)"End of input stream reached, client disconnected");
        }
        catch (IOException e) {
            if (this.gracefulClosed) {
                Log.info((String)"Connection to dashboard client was closed graceful");
            } else {
                Log.info((String)("Dashboard Client disconnected ungraceful. Cause : " + e.getMessage()));
            }
        }
        finally {
            this.shutdown();
        }
    }

    protected void rejectionToOutputQueue(String output) {
        this.writeToOutputQueue(output);
        this.statistics.actionsRejected();
    }

    protected void executionToOutputQueue(String output) {
        this.writeToOutputQueue(output);
        this.statistics.actionExecuted();
    }

    protected void writeToOutputQueue(final String output) {
        this.outputExecuterService.execute(new Runnable(){

            @Override
            public void run() {
                DashboardClient.this.writeToOutputDirectly(output);
            }

            public String toString() {
                return output;
            }
        });
    }

    protected void writeToOutputDirectly(String output) {
        if (!this.clientSocket.isClosed()) {
            this.clientOutput.println(output);
        }
        if (this.isDisconnected(output)) {
            this.shutdown();
        }
    }

    protected void shutdown() {
        if (!this.isShutdown) {
            this.isShutdown = true;
            int inputQueueDepth = this.shutdownAndAwaitTermination(this.inputExecuterService, 10L);
            int outputQueueDepth = this.shutdownAndAwaitTermination(this.outputExecuterService, 500L);
            if (inputQueueDepth > 0 || outputQueueDepth > 0) {
                String log = "Dashboard Client disconnected before all actions was executed - Unhandled actions in queues: input(" + inputQueueDepth + ") output(" + outputQueueDepth + ")";
                this.writeToOutputDirectly(log);
            }
            this.closeClientSocket();
            this.statistics.logStats(inputQueueDepth, outputQueueDepth);
        }
    }

    protected int shutdownAndAwaitTermination(ExecutorService pool, long milliSeconds) {
        int queueDepth = 0;
        pool.shutdown();
        try {
            if (!pool.awaitTermination(milliSeconds, TimeUnit.MILLISECONDS)) {
                queueDepth = pool.shutdownNow().size();
            }
        }
        catch (InterruptedException ie) {
            queueDepth = pool.shutdownNow().size();
            Thread.currentThread().interrupt();
        }
        return queueDepth;
    }

    private void closeClientSocket() {
        try {
            if (!this.clientSocket.isClosed()) {
                this.clientSocket.close();
            }
        }
        catch (IOException e) {
            Log.warning((String)"Unable to close DashboardClient connection", (Throwable)e);
        }
    }

    private boolean isDisconnected(String output) {
        this.gracefulClosed = DISCONNECTED.equals(output);
        return this.gracefulClosed;
    }
}

