/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.InputProcessor;
import com.ur.polyscope.dashboardserver.impl.DashboardClient;
import com.ur.polyscope.dashboardserver.impl.NotifyOnPolyScopeStarted;
import com.ur.util.Waiting;
import com.ur.util.logging.Log;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.TimeUnit;

final class DashboardServerConnectionCreatorThread
extends Thread {
    public static final String DASHBOARD_SERVER_THREAD = "DashboardServerConnectionCreatorThread";
    private final ServerSocket serverSocket;
    private final InputProcessor processor;
    private NotifyOnPolyScopeStarted notifyOnPolyScopeStarted;

    DashboardServerConnectionCreatorThread(ServerSocket serverSocket, NotifyOnPolyScopeStarted notifyOnPolyScopeStarted, InputProcessor processor) {
        super(DASHBOARD_SERVER_THREAD);
        this.notifyOnPolyScopeStarted = notifyOnPolyScopeStarted;
        if (serverSocket == null) {
            throw new IllegalArgumentException("serverSocket is null");
        }
        this.processor = processor;
        this.serverSocket = serverSocket;
    }

    @Override
    public void run() {
        Waiting.until((Waiting.ItHappens)this.notifyOnPolyScopeStarted, (int)1, (TimeUnit)TimeUnit.MINUTES);
        while (!this.isInterrupted() && !this.serverSocket.isClosed()) {
            try {
                Socket clientSocket = this.serverSocket.accept();
                new DashboardClient(clientSocket, this.processor).start();
            }
            catch (SocketException se) {
                Log.info((String)("DashBoardServer client disconnected unexpectedly: " + se.getMessage()));
            }
            catch (Exception e) {
                Log.error((String)"DashBoardServer connection thread creation problem: ", (Throwable)e);
            }
        }
    }

    void stopThread() throws IOException {
        this.serverSocket.close();
        Log.info((String)("Interrupting " + this.getName()));
        this.interrupt();
        Log.info((String)("Shutting down thread " + this.getName()));
    }
}

