/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;

class LogAndCaptureActionResults
implements DashBoardAction {
    private static final Logger LOGGER = LogFactory.createLogger(LogAndCaptureActionResults.class);
    private final DashBoardAction action;

    public LogAndCaptureActionResults(DashBoardAction action) {
        this.action = action;
    }

    public boolean canHandleMessage(String input) {
        return this.action.canHandleMessage(input);
    }

    public String execute(String inputLine) {
        try {
            LOGGER.traceRoute((Object)("Executing dashboard action: " + inputLine));
            String dashboardActionResponse = this.action.execute(inputLine);
            LOGGER.trace("Completed execution of dashboard action: " + inputLine + ". Sending response: " + dashboardActionResponse, new Object[0]);
            return dashboardActionResponse;
        }
        catch (Exception e) {
            LOGGER.error("Failed to perform execution: " + inputLine, (Throwable)e);
            return "Failed to perform execution: " + inputLine;
        }
    }
}

