/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.InputProcessor;
import com.ur.dashboardserver.ReadOnlyDashboardAction;
import com.ur.dashboardserver.processors.ConditionalInputProcessor;
import com.ur.polyscope.dashboardserver.impl.ActionLocator;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;

class ReadOnlyInputProcessor
implements InputProcessor {
    private final ActionLocator actions;
    private final Set<ConditionalInputProcessor> inputProcessors;

    @Inject
    public ReadOnlyInputProcessor(Set<DashBoardAction> actions, Set<ConditionalInputProcessor> inputProcessors) {
        this.actions = new ActionLocator(ReadOnlyInputProcessor.enforceReadOnlyActions(actions));
        this.inputProcessors = inputProcessors;
    }

    public String process(String inputLine) {
        for (ConditionalInputProcessor each : this.inputProcessors) {
            if (!each.isActive()) continue;
            return each.process(inputLine);
        }
        return this.actions.locateAction(inputLine).execute(inputLine);
    }

    private static Set<DashBoardAction> enforceReadOnlyActions(Set<DashBoardAction> actions) {
        HashSet<DashBoardAction> readOnlyActions = new HashSet<DashBoardAction>();
        for (DashBoardAction each : actions) {
            readOnlyActions.add(ReadOnlyInputProcessor.createWriteProtectedAction(each));
        }
        return readOnlyActions;
    }

    private static DashBoardAction createWriteProtectedAction(DashBoardAction action) {
        if (ReadOnlyInputProcessor.shouldWriteProtectAction(action)) {
            return new WriteProtectedAction(action);
        }
        return action;
    }

    private static boolean shouldWriteProtectAction(DashBoardAction action) {
        return !ReadOnlyInputProcessor.ignoreIfDeveloperMode() && !ReadOnlyInputProcessor.isReadOnlyAnnotated(action);
    }

    private static boolean isReadOnlyAnnotated(DashBoardAction action) {
        return action.getClass().isAnnotationPresent(ReadOnlyDashboardAction.class);
    }

    private static boolean ignoreIfDeveloperMode() {
        return Boolean.parseBoolean(System.getProperties().getProperty("RunningInDevelopmentMode"));
    }

    private static class WriteProtectedAction
    implements DashBoardAction {
        private final DashBoardAction action;

        WriteProtectedAction(DashBoardAction action) {
            this.action = action;
        }

        public boolean canHandleMessage(String input) {
            return this.action.canHandleMessage(input);
        }

        public String execute(String input) {
            return "Command is not allowed due to safety reasons, please switch robot to Remote Control mode and reconnect to port 29999";
        }
    }
}

