/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.dashboardserver.DashBoardAction;
import com.ur.dashboardserver.InputProcessor;
import com.ur.dashboardserver.processors.ConditionalInputProcessor;
import com.ur.polyscope.dashboardserver.impl.ActionLocator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
class StandardInputProcessor
implements InputProcessor {
    private final ActionLocator actions;
    private final Set<ConditionalInputProcessor> inputProcessors;

    @Inject
    public StandardInputProcessor(Set<DashBoardAction> actions, Set<ConditionalInputProcessor> inputProcessors) {
        this.actions = new ActionLocator(actions);
        this.inputProcessors = inputProcessors;
    }

    public synchronized String process(String inputLine) {
        for (ConditionalInputProcessor each : this.inputProcessors) {
            if (!each.isActive()) continue;
            return each.process(inputLine);
        }
        return this.actions.locateAction(inputLine).execute(inputLine);
    }
}

