/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.dashboardserver.impl;

import com.ur.util.logging.Log;

public class Statistics {
    private static final ConnectionTime CONNECTION_TIME = new ConnectionTime();
    private long actionsReceived = 0L;
    private long actionsExecuted = 0L;
    private long actionsRejected = 0L;

    public void actionsReceived() {
        ++this.actionsReceived;
    }

    public void actionExecuted() {
        ++this.actionsExecuted;
    }

    public void actionsRejected() {
        ++this.actionsRejected;
    }

    public void logStats(long inputQueueDepth, long outputQueueDepth) {
        String stats = "Dashboard Client statistics\nConnection time             : " + CONNECTION_TIME.elapsedTime() + "\nActions received            : " + this.actionsReceived + "\nActions rejected            : " + this.actionsRejected + "\nActions executed            : " + this.actionsExecuted + "\nUnhandled actions in queued : " + inputQueueDepth + "\nUnhandled outputs in queued : " + outputQueueDepth + "\n";
        this.outputStatisticsResults(inputQueueDepth, outputQueueDepth, stats);
    }

    private void outputStatisticsResults(long inputQueueDepth, long outputQueueDepth, String stats) {
        if (this.actionsRejected > 0L || inputQueueDepth > 0L || outputQueueDepth > 0L) {
            Log.warning((String)stats);
        } else {
            Log.info((String)stats);
        }
    }

    private static class ConnectionTime {
        private static final long START_TIME = System.currentTimeMillis();

        private ConnectionTime() {
        }

        public String elapsedTime() {
            long elapsedTimeInMillis = System.currentTimeMillis() - START_TIME;
            return this.getFormattedConnectionTime(elapsedTimeInMillis);
        }

        private String getFormattedConnectionTime(long timeInMilliSeconds) {
            long seconds = timeInMilliSeconds / 1000L;
            long minutes = seconds / 60L;
            long hours = minutes / 60L;
            long days = hours / 24L;
            return days + " days " + hours % 24L + " hours " + minutes % 60L + " minutes " + seconds % 60L + " seconds";
        }
    }
}

