/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ControlsImageResource {
    private static boolean isG5 = true;

    private ControlsImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/controls/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="manual_highspeed.png")
    public static Icon manualHighspeed() {
        return ControlsImageResource.tryGetImage("manual_highspeed.png");
    }

    @Key(value="manual_highspeed_yellow.png")
    public static Icon manualHighspeedYellow() {
        return ControlsImageResource.tryGetImage("manual_highspeed_yellow.png");
    }

    @Key(value="pause_speedslider.png")
    public static Icon pauseSpeedslider() {
        return ControlsImageResource.tryGetImage("pause_speedslider.png");
    }

    @Key(value="safe-home.png")
    public static Icon safeHome() {
        return ControlsImageResource.tryGetImage("safe-home.png");
    }

    @Key(value="advance.png")
    public static Icon advance() {
        return ControlsImageResource.tryGetImage("advance.png");
    }

    @Key(value="play.png")
    public static Icon play() {
        return ControlsImageResource.tryGetImage("play.png");
    }

    @Key(value="bigStop.png")
    public static Icon bigStop() {
        return ControlsImageResource.tryGetImage("bigStop.png");
    }

    @Key(value="pause.png")
    public static Icon pause() {
        return ControlsImageResource.tryGetImage("pause.png");
    }

    @Key(value="disabled_speedslider.png")
    public static Icon disabledSpeedslider() {
        return ControlsImageResource.tryGetImage("disabled_speedslider.png");
    }

    @Key(value="resume.png")
    public static Icon resume() {
        return ControlsImageResource.tryGetImage("resume.png");
    }

    @Key(value="bigPlay.png")
    public static Icon bigPlay() {
        return ControlsImageResource.tryGetImage("bigPlay.png");
    }

    @Key(value="stop.png")
    public static Icon stop() {
        return ControlsImageResource.tryGetImage("stop.png");
    }

    @Key(value="manual_highspeed_slide.png")
    public static Icon manualHighspeedSlide() {
        return ControlsImageResource.tryGetImage("manual_highspeed_slide.png");
    }

    @Key(value="bigResume.png")
    public static Icon bigResume() {
        return ControlsImageResource.tryGetImage("bigResume.png");
    }

    @Key(value="bigPause.png")
    public static Icon bigPause() {
        return ControlsImageResource.tryGetImage("bigPause.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ControlsImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            ControlsImageResource.tryGetImage("manual_highspeed.png");
            ControlsImageResource.tryGetImage("manual_highspeed_yellow.png");
            ControlsImageResource.tryGetImage("pause_speedslider.png");
            ControlsImageResource.tryGetImage("safe-home.png");
            ControlsImageResource.tryGetImage("advance.png");
            ControlsImageResource.tryGetImage("play.png");
            ControlsImageResource.tryGetImage("bigStop.png");
            ControlsImageResource.tryGetImage("pause.png");
            ControlsImageResource.tryGetImage("disabled_speedslider.png");
            ControlsImageResource.tryGetImage("resume.png");
            ControlsImageResource.tryGetImage("bigPlay.png");
            ControlsImageResource.tryGetImage("stop.png");
            ControlsImageResource.tryGetImage("manual_highspeed_slide.png");
            ControlsImageResource.tryGetImage("bigResume.png");
            ControlsImageResource.tryGetImage("bigPause.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

