/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class MenuImageResource {
    private static boolean isG5 = true;

    private MenuImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/menu/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="installation_small.png")
    public static Icon installationSmall() {
        return MenuImageResource.tryGetImage("installation_small.png");
    }

    @Key(value="new_file_icon_white.png")
    public static Icon newFileIconWhite() {
        return MenuImageResource.tryGetImage("new_file_icon_white.png");
    }

    @Key(value="manual_large.png")
    public static Icon manualLarge() {
        return MenuImageResource.tryGetImage("manual_large.png");
    }

    @Key(value="manual_warning_large.png")
    public static Icon manualWarningLarge() {
        return MenuImageResource.tryGetImage("manual_warning_large.png");
    }

    @Key(value="automatic_large.png")
    public static Icon automaticLarge() {
        return MenuImageResource.tryGetImage("automatic_large.png");
    }

    @Key(value="open_file_icon_white.png")
    public static Icon openFileIconWhite() {
        return MenuImageResource.tryGetImage("open_file_icon_white.png");
    }

    @Key(value="manual_warning_small.png")
    public static Icon manualWarningSmall() {
        return MenuImageResource.tryGetImage("manual_warning_small.png");
    }

    @Key(value="save_file_icon_white.png")
    public static Icon saveFileIconWhite() {
        return MenuImageResource.tryGetImage("save_file_icon_white.png");
    }

    @Key(value="automatic_small.png")
    public static Icon automaticSmall() {
        return MenuImageResource.tryGetImage("automatic_small.png");
    }

    @Key(value="installation_small_hover.png")
    public static Icon installationSmallHover() {
        return MenuImageResource.tryGetImage("installation_small_hover.png");
    }

    @Key(value="manual_small.png")
    public static Icon manualSmall() {
        return MenuImageResource.tryGetImage("manual_small.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return MenuImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    static {
        if (isG5) {
            MenuImageResource.tryGetImage("installation_small.png");
            MenuImageResource.tryGetImage("new_file_icon_white.png");
            MenuImageResource.tryGetImage("manual_large.png");
            MenuImageResource.tryGetImage("manual_warning_large.png");
            MenuImageResource.tryGetImage("automatic_large.png");
            MenuImageResource.tryGetImage("open_file_icon_white.png");
            MenuImageResource.tryGetImage("manual_warning_small.png");
            MenuImageResource.tryGetImage("save_file_icon_white.png");
            MenuImageResource.tryGetImage("automatic_small.png");
            MenuImageResource.tryGetImage("installation_small_hover.png");
            MenuImageResource.tryGetImage("manual_small.png");
        }
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = path + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

