/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.conceptimpl;

import com.ur.g5.conceptimpl.PolyscopePersistenceFacade;
import com.ur.g5.conceptimpl.ProgramData;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.util.logging.Log;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.program.ProgramRootNodeLoad;
import gui.program.ProgramRootNodeSave;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.zip.GZIPInputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PolyscopePersistenceImpl
implements PolyscopePersistenceFacade {
    public static final String COULD_NOT_READ_FROM_PROGRAM_FILE = "Could not read from program file";
    private ProgramRootNodeSave programRootNodeSave;

    public PolyscopePersistenceImpl(ProgramRootNodeSave programRootNodeSave) {
        this.programRootNodeSave = programRootNodeSave;
    }

    @Override
    public boolean updateProgram(ConceptLocation conceptLocation, ProgramData programData) {
        try {
            File programFile = new File(conceptLocation.getFullPath());
            ProgramRootNode programRootNode = ProgramRootNodeLoad.deserializeProgram((File)programFile);
            if (programRootNode == null) {
                return false;
            }
            FileManagementProgramComponent component = (FileManagementProgramComponent)programRootNode.getComponent(FileManagementProgramComponent.class);
            component.setProgramDirectory(programData.getDirectory());
            programRootNode.setName(programData.getName());
            component.setInstallationRelativePath(programData.getInstallationPath());
            this.programRootNodeSave.actualSaveOnlyProgram(programRootNode, programFile);
        }
        catch (Exception e) {
            Log.error((String)("Cannot deserialize program " + conceptLocation.getFullPath()), (Throwable)e);
            return false;
        }
        return true;
    }

    @Override
    public ProgramData getProgramData(ConceptLocation conceptLocation) {
        try {
            File programFile = new File(conceptLocation.getFullPath());
            return this.readUrProgramNodeFromProgram(programFile);
        }
        catch (Exception e) {
            Log.error((String)("Cannot deserialize program " + conceptLocation.getFullPath()), (Throwable)e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ProgramData readUrProgramNodeFromProgram(File programFile) {
        try (InputStream stream = Files.newInputStream(programFile.toPath(), new OpenOption[0]);){
            URXMLHandler handler = new URXMLHandler();
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            saxParser.setProperty("http://javax.xml.XMLConstants/property/accessExternalSchema", "");
            if (URFileUtils.isGZippedFile((File)programFile)) {
                GZIPInputStream unzippedStream = new GZIPInputStream(stream);
                saxParser.parse((InputStream)unzippedStream, (DefaultHandler)handler);
            } else {
                saxParser.parse(stream, (DefaultHandler)handler);
            }
            ProgramData programData = handler.getProgram();
            return programData;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            Log.error((String)COULD_NOT_READ_FROM_PROGRAM_FILE, (Throwable)e);
            return null;
        }
    }

    private class URXMLHandler
    extends DefaultHandler {
        private ProgramData program;

        private URXMLHandler() {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            if (qName.equals("URProgram")) {
                boolean isLegacyProgram = true;
                this.program = new ProgramData("", "", "");
                for (int i = 0; i < attributes.getLength(); ++i) {
                    if (attributes.getQName(i).equals("name")) {
                        this.program.setName(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("directory")) {
                        this.program.setDirectory(attributes.getValue(i));
                        continue;
                    }
                    if (attributes.getQName(i).equals("installationRelativePath")) {
                        isLegacyProgram = false;
                        this.program.setInstallationPath(attributes.getValue(i));
                        continue;
                    }
                    if (!attributes.getQName(i).equals("installation") || !isLegacyProgram) continue;
                    this.program.setInstallationPath(attributes.getValue(i));
                }
            }
        }

        public ProgramData getProgram() {
            return this.program;
        }
    }
}

