/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.conceptimpl;

import com.ur.disk.Directories;
import com.ur.g5.conceptimpl.InstallationResourceImpl;
import com.ur.g5.conceptimpl.NullInstallationResourceImpl;
import com.ur.g5.conceptimpl.PolyscopePersistenceFacade;
import com.ur.g5.conceptimpl.PolyscopePersistenceImpl;
import com.ur.g5.conceptimpl.ProgramResourceImpl;
import com.ur.polyscope.concept.operations.ProgramInstallationService;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.ConceptLocationFactory;
import com.ur.polyscope.concept.operations.resource.InstallationResource;
import com.ur.polyscope.concept.operations.resource.ProgramResource;
import com.ur.util.logging.Log;
import gui.program.ProgramRootNodeSave;
import java.io.File;
import javax.inject.Inject;

public class ProgramInstallationServiceImpl
implements ProgramInstallationService {
    private final File programDirectory;
    private final PolyscopePersistenceFacade polyscopePersistenceFacade;
    private final ConceptLocationFactory conceptLocationFactory;

    @Inject
    public ProgramInstallationServiceImpl(ProgramRootNodeSave programRootNodeSave, ConceptLocationFactory conceptLocationFactory) {
        this(new PolyscopePersistenceImpl(programRootNodeSave), Directories.programs(), conceptLocationFactory);
    }

    public ProgramInstallationServiceImpl(PolyscopePersistenceFacade polyscopePersistenceFacade, File programDirectory, ConceptLocationFactory conceptLocationFactory) {
        this.conceptLocationFactory = conceptLocationFactory;
        this.programDirectory = programDirectory;
        this.polyscopePersistenceFacade = polyscopePersistenceFacade;
    }

    public ProgramResource getProgram(ConceptLocation source) {
        return new ProgramResourceImpl(source, this);
    }

    public InstallationResource getInstallation(ConceptLocation source) {
        if (new File(source.getFullPath()).exists()) {
            return new InstallationResourceImpl(source, this);
        }
        Log.warning((String)("Source at " + source.getFullPath() + " does not exist"));
        return new NullInstallationResourceImpl();
    }

    public PolyscopePersistenceFacade getPolyscopePersistenceFacade() {
        return this.polyscopePersistenceFacade;
    }

    public File getProgramDirectory() {
        return this.programDirectory;
    }

    public ConceptLocationFactory getConceptLocationFactory() {
        return this.conceptLocationFactory;
    }
}

