/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.conceptimpl;

import com.ur.g5.conceptimpl.InstallationResourceImpl;
import com.ur.g5.conceptimpl.NullInstallationResourceImpl;
import com.ur.g5.conceptimpl.ProgramData;
import com.ur.g5.conceptimpl.ProgramInstallationServiceImpl;
import com.ur.polyscope.concept.operations.location.ConceptLocation;
import com.ur.polyscope.concept.operations.location.Types;
import com.ur.polyscope.concept.operations.resource.InstallationResource;
import com.ur.polyscope.concept.operations.resource.ProgramResource;
import com.ur.util.logging.Log;
import gui.tools.URFileUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;

public class ProgramResourceImpl
implements ProgramResource {
    private final ConceptLocation location;
    private final ProgramInstallationServiceImpl programService;

    public ProgramResourceImpl(ConceptLocation conceptLocation, ProgramInstallationServiceImpl programService) {
        this.location = conceptLocation;
        this.programService = programService;
    }

    public InstallationResource getInstallation() {
        return this.obtainInstallationFromRootNode();
    }

    public boolean setInstallation(InstallationResource installation) {
        InstallationResource currentInstallation = this.getInstallation();
        ConceptLocation currentLocation = currentInstallation.getLocation();
        ConceptLocation newLocation = installation.getLocation();
        if (currentLocation != null && currentLocation.equals(newLocation)) {
            return false;
        }
        if (!installation.exists()) {
            return false;
        }
        return this.setInstallation(installation.getLocation());
    }

    public boolean setInstallation(ConceptLocation installation) {
        String relativePath;
        try {
            relativePath = URFileUtils.relativizeInstallationPath((String)new File(this.location.getFullPath()).getCanonicalPath(), (String)new File(installation.getFullPath()).getCanonicalPath());
        }
        catch (Exception e) {
            Log.error((String)"Could not set installation properly", (Throwable)e);
            return false;
        }
        return this.rescanAll(relativePath);
    }

    public boolean isPathOnUSB(File file) {
        try {
            String canonicalFilePath = file.getCanonicalPath();
            return canonicalFilePath.startsWith("/media");
        }
        catch (IOException e) {
            Log.error((String)"Exception caught, trying to decide if file is a symlink ", (Throwable)e);
            return false;
        }
    }

    private boolean rescanAll(String installationPath) {
        try {
            ProgramData programData = this.loadFromFile();
            if (programData == null) {
                return false;
            }
            String trimmedLocationName = FilenameUtils.removeExtension((String)this.location.getName());
            programData.setName(trimmedLocationName);
            File programFile = new File(this.location.getPath());
            String pathToUse = programFile.getCanonicalPath();
            if (this.isPathOnUSB(programFile)) {
                Log.debug((String)"Location is on a USB");
                pathToUse = programFile.getPath();
            }
            programData.setDirectory(this.programService.getProgramDirectory() + URFileUtils.relativizeProgramPath((String)this.programService.getProgramDirectory().getCanonicalPath(), (String)pathToUse));
            programData.setInstallationPath(installationPath);
            return this.saveToFile(programData);
        }
        catch (Exception e) {
            Log.error((String)"Unable to rescan file", (Throwable)e);
            return false;
        }
    }

    private boolean saveToFile(ProgramData programData) {
        return this.programService.getPolyscopePersistenceFacade().updateProgram(this.location, programData);
    }

    private ProgramData loadFromFile() {
        return this.programService.getPolyscopePersistenceFacade().getProgramData(this.location);
    }

    private InstallationResource obtainInstallationFromRootNode() {
        try {
            ProgramData programData = this.loadFromFile();
            String installationPath = programData.getInstallationPath();
            File programFile = new File(this.location.getFullPath());
            File installationFile = this.obtainInstallationFile(programFile, installationPath);
            ConceptLocation installationSource = this.programService.getConceptLocationFactory().get(FilenameUtils.removeExtension((String)installationFile.getName()), installationFile.getParentFile().getPath(), Types.getInstallation());
            return new InstallationResourceImpl(installationSource, this.programService);
        }
        catch (Exception e) {
            Log.error((String)("Unable to deserialize " + this.location.getFullPath()), (Throwable)e);
            return new NullInstallationResourceImpl();
        }
    }

    private File obtainInstallationFile(File programFile, String installationPath) {
        String fullPath = programFile.getParentFile().getPath() + File.separator + installationPath + ".installation";
        String canonicalPath = URFileUtils.unrelativizePath((String)fullPath);
        return new File(canonicalPath);
    }

    public ConceptLocation getLocation() {
        return this.location;
    }

    public boolean exists() {
        return new File(this.location.getFullPath()).exists();
    }
}

