/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import java.awt.Container;
import javax.swing.BoxLayout;
import javax.swing.JLabel;

public class ExpertLockedPanel
extends CardPanel {
    private final ViewContext viewContext;
    private JLabel title;
    private JLabel description;

    public ExpertLockedPanel(ViewContext viewContext) {
        this.viewContext = viewContext;
        this.initializeComponent();
    }

    public void enter(Object o) {
        super.enter(o);
        if (o instanceof Info) {
            Info info = (Info)o;
            this.title.setText(info.title);
            this.description.setText(info.description);
        }
    }

    private void initializeComponent() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        this.title = new JLabel(textResource.panelLockedTitle());
        this.title.setFont(fontFactory.getRelativeFont(URFontFactory.Style.BOLD, URFontFactory.Size.LARGE));
        this.title.setAlignmentX(0.5f);
        this.description = new JLabel(textResource.panelLockedDescription());
        this.description.setAlignmentX(0.5f);
        this.setLayout(new BoxLayout((Container)((Object)this), 3));
        this.add(this.title);
        this.add(this.description);
    }

    public static class Info {
        public final String title;
        private final String description;

        public Info(String title, String description) {
            this.title = title;
            this.description = description;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

