/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.TextResource;
import com.ur.g5.expert.ExpertTabCardPanels;
import com.ur.g5.expert.FTCalibrationFeatureToggle;
import com.ur.g5.expert.JointZeroingPanel;
import com.ur.g5.expert.ShowExpertFileEditor;
import com.ur.g5.util.NavigateBackAction;
import com.ur.polyscope.calibration.MainCalibrationImpl;
import com.ur.polyscope.calibration.forcetorque.FTCalibrationPanel;
import com.ur.polyscope.core.api.annotation.NoControlButtonVisibilityChange;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.swing.ArgumentProvider;
import com.ur.swing.CardPanel;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.extensible.ExtensionPoint;
import com.ur.swing.extensible.Menu;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventNotificationService;
import com.ur.view.Settings;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.BorderFactory;

@ExtensionPoint(value="ExpertScreen")
@Singleton
@NoControlButtonVisibilityChange
public class ExpertTab
extends CardPanel
implements Menu {
    public static final String EXIT_EXPERT_SCREEN = "exit.ExpertScreen";
    private final FlippablePanel flipPanel;
    private final Provider<BaseAccordionView> baseAccordionViewProvider;
    private final ViewContext viewContext;
    private final TextResource textResource;
    private final ShowExpertFileEditor showExpertFileEditor;
    private BaseAccordionView navigation;

    @Inject
    ExpertTab(Provider<BaseAccordionView> baseAccordionViewProvider, ExpertTabCardPanels expertTabCardPanels, ViewContext viewContext, ShowExpertFileEditor showExpertFileEditor) {
        this.viewContext = viewContext;
        this.baseAccordionViewProvider = baseAccordionViewProvider;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.showExpertFileEditor = showExpertFileEditor;
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.flipPanel = new FlippablePanel();
        this.flipPanel.setCardParent((CardPanel)this);
        this.add((Component)this.flipPanel, "Center");
        expertTabCardPanels.addCardPanels(this.flipPanel, viewContext);
        this.navigateToDefaultPanel();
    }

    private void navigateToDefaultPanel() {
        this.flipPanel.switchTo(MainCalibrationImpl.class, null);
    }

    public void setFlipManager(FlipManager flipManager) {
        super.setFlipManager(flipManager);
        this.addNavigationSidebar();
    }

    public void enter(Object o) {
        super.enter(o);
        if (o != null) {
            this.navigation.selectSection((FlipManager)this.flipPanel, (BaseAccordionView.ComponentRelation)new ButtonLocator(o));
        }
        this.flipPanel.enterActiveChild(o);
        EventNotificationService.notify(VetoListener.class, listener -> listener.veto(ExpertTab.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
    }

    public Object exit() {
        this.flipPanel.exitActiveChild();
        return super.exit();
    }

    private void addNavigationSidebar() {
        this.navigation = (BaseAccordionView)this.baseAccordionViewProvider.get();
        this.navigation.setLanguage(Settings.getLanguage());
        com.ur.i18n.TextResource oldTextResource = (com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.navigation.addItem(this.createNavigationButton(MainCalibrationImpl.class, oldTextResource.tabCalibration(), null));
        if (FTCalibrationFeatureToggle.isActive()) {
            this.navigation.addItem(this.createNavigationButton(FTCalibrationPanel.class, this.textResource.forceTorqueCalibration(), null));
        }
        this.navigation.addItem(this.createNavigationButton(JointZeroingPanel.class, this.textResource.jointZeroing(), null));
        this.showExpertFileEditor.putValue("Name", oldTextResource.fileEditor());
        this.showExpertFileEditor.setFlippablePanel(this.flipPanel);
        this.navigation.addItem((Action)this.showExpertFileEditor);
        this.add((Component)this.navigation, "West");
        this.navigation.setExitAction((Action)((Object)new ExitExpertTab(this.flipManager)));
        this.navigation.setPreferredSize(new Dimension(220, -1));
    }

    private Action createNavigationButton(Class<? extends CardPanel> cardType, String title, Object argument) {
        ShowScreenActionImpl action = new ShowScreenActionImpl(cardType, (FlipManager)this.flipPanel, false, (ArgumentProvider)new ArgumentProvider.Single(argument));
        action.putValue("Name", (Object)title);
        return action;
    }

    public void addMenuItem(MenuExtension.MenuContribution menuContribution) {
        this.navigation.addItem(menuContribution.contribution);
        CardPanel panel = (CardPanel)menuContribution.contribution.getValue("cardPanel");
        ((ShowScreenActionImpl)menuContribution.contribution).setFlipManager((FlipManager)this.flipPanel);
        if (panel != null) {
            this.flipPanel.addCardPanel(panel);
        }
    }

    private static class ButtonLocator
    implements BaseAccordionView.ComponentRelation {
        private final Object toLookFor;

        public ButtonLocator(Object toLookFor) {
            this.toLookFor = toLookFor;
        }

        public Object getTargetObject() {
            return this.toLookFor;
        }

        public boolean sameLeaf(Component component) {
            return false;
        }
    }

    private final class ExitExpertTab
    extends NavigateBackAction {
        private ExitExpertTab(FlipManager flipManager) {
            super(flipManager, ExpertTab.EXIT_EXPERT_SCREEN);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ExpertTab.this.navigateToDefaultPanel();
            EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(ExpertTab.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
            super.actionPerformed(e);
        }
    }
}

