/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.TextResource;
import com.ur.g5.expert.JointZeroingSelectionPanel;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.lang.react.RecipeHelper;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.move.JointPaintStrategy;
import com.ur.move.JointPositionIndicator;
import com.ur.move.JointPositionVectorPanel;
import com.ur.move.MoveTabRobotModel;
import com.ur.move.MoveTabRobotView;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.robot.configuration.joint.JointConfigurationSettings;
import com.ur.polyscope.robot.configuration.joint.JointPositionRangeProvider;
import com.ur.polyscope.viewfacade.footercontrols.ControlsSite;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3D;
import com.ur.polyscope.visualizer.canvas.RobotCanvas3DFactory;
import com.ur.polyscope.visualizer.canvasbehavior.ViewBehaviorHolder;
import com.ur.polyscope.visualizer.canvasbehavior.ZoomRenderer;
import com.ur.polyscope.visualizer.geomfeature.ViewableGeomFeature;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.polyscope.visualizer.panel.ElementsVisualizerAggregator;
import com.ur.swing.CardPanel;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.constants.dev.SafetyMode;
import gui.polyscope.setup.treenodes.geom.SetupFeatureContainerNode;
import gui.tools.DialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.inject.Inject;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;

public class JointZeroingPanel
extends CardPanel {
    private final MoveTabRobotView robotView;
    private final JointPaintStrategy jointPaintStrategy;
    private InstallationComponentLookup installationLookup;
    private MoveTabRobotModel robotModel;
    private ControlsSite controlsSite;
    private JointZeroingSelectionPanel jointZeroingSelectionPanel;
    private final RecipeHelper recipeHelper = new RecipeHelper();

    @Inject
    public JointZeroingPanel(ElementsVisualizerAggregator elementsVisualizerAggregator, MoveTabRobotModel robotModel, ViewContext viewContext, JointConfigurationSettings configurationSettings, JointPositionRangeProvider rangeProvider, InstallationComponentLookup installationLookup, ControlsSite controlsSite, DialogCreator dialogCreator, RobotCanvas3DFactory robotCanvas3DFactory, ControllerInterface controllerInterface, @Source(value=RobotState.class) Recipe<RobotState> robotStateRecipe) {
        this.installationLookup = installationLookup;
        this.robotModel = robotModel;
        this.controlsSite = controlsSite;
        this.recipeHelper.add(RobotState.class, robotStateRecipe, (Consumer)new MoveTabRobotStateListener());
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        JPanel warningMessagePanel = viewContext.createWidgetFactory().createWarningMessagePanel(textResource.jointZeroingWarningMessage());
        this.robotView = new MoveTabRobotView(elementsVisualizerAggregator, robotModel, robotCanvas3DFactory, false, controllerInterface, "Joint Zeroing 3D Canvas");
        this.jointZeroingSelectionPanel = new JointZeroingSelectionPanel(viewContext, dialogCreator, this, robotStateRecipe);
        JointPositionVectorPanel jointPositionVectorPanel = new JointPositionVectorPanel(viewContext, robotModel);
        this.setLayout(new BorderLayout(5, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        RobotCanvas3D robotCanvas3D = this.robotView.getRobotCanvas3D();
        robotCanvas3D.addJ3DComponent((J3DComponent)new ZoomRenderer(robotCanvas3D.getComponent(), (ViewBehaviorHolder)robotModel));
        this.robotView.setBorder((Border)new CardBorder(((com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class)).Robot()));
        this.jointPaintStrategy = new JointPaintStrategy(rangeProvider, jointPositionVectorPanel.getJointPositionIndicators().toArray(new JointPositionIndicator[jointPositionVectorPanel.getJointPositionIndicators().size()]), jointPositionVectorPanel.getJointPositionFields().toArray(new JTextField[jointPositionVectorPanel.getJointPositionFields().size()]), new JTextField[0], jointPositionVectorPanel.getJointRevolutionLabels().toArray(new JLabel[jointPositionVectorPanel.getJointRevolutionLabels().size()]));
        this.jointPaintStrategy.setConfigurationSettings(configurationSettings);
        this.add(warningMessagePanel, "North");
        this.add((Component)this.robotView, "Center");
        this.jointZeroingSelectionPanel.setPreferredSize(new Dimension(300, 0));
        this.add(this.jointZeroingSelectionPanel, "West");
        this.add((Component)jointPositionVectorPanel, "East");
    }

    public void enter(Object o) {
        this.controlsSite.requestControls(new ControlsSite.DashboardOptions[]{ControlsSite.DashboardOptions.SPEED_SLIDER});
        this.jointPaintStrategy.setEnabledOnAllTextFields(true);
        this.jointPaintStrategy.paintJointLimits(((RobotState)this.recipeHelper.lastProviderValue(RobotState.class)).reducedModeActive, true);
        this.jointPaintStrategy.hideTargetPositions();
        this.robotView.updateRobotState((RobotState)this.recipeHelper.lastProviderValue(RobotState.class));
        this.jointZeroingSelectionPanel.enter();
        this.robotModel.setJoggableGeomFeature((ViewableGeomFeature)((SetupFeatureContainerNode)this.installationLookup.getComponent(SetupFeatureContainerNode.class)).getCameraView());
        this.robotView.enter();
        this.recipeHelper.subscribe(RobotState.class);
    }

    public Object exit() {
        this.controlsSite.requestControls(new ControlsSite.DashboardOptions[0]);
        this.robotView.exit();
        this.recipeHelper.unsubscribe(RobotState.class);
        this.jointZeroingSelectionPanel.exit();
        return super.exit();
    }

    private class MoveTabRobotStateListener
    implements Consumer<RobotState> {
        private boolean performUpdateOfTextField = true;

        private MoveTabRobotStateListener() {
        }

        public void accept(RobotState rs) {
            this.performUpdateOfTextField = !this.performUpdateOfTextField;
            JointPositionVector jointPositionVector = rs.jointPosition;
            JointZeroingPanel.this.robotView.updateRobotState(rs);
            JointZeroingPanel.this.jointPaintStrategy.setEnabledOnAllTextFields(rs.masterSafetyState != SafetyMode.RECOVERY);
            JointZeroingPanel.this.jointPaintStrategy.paintJointLimits(rs.reducedModeActive, false);
            JointZeroingPanel.this.jointPaintStrategy.setPositionsValues(jointPositionVector);
            if (this.performUpdateOfTextField) {
                JointZeroingPanel.this.jointPaintStrategy.paintJointText(jointPositionVector, rs.reducedModeActive);
            }
        }
    }
}

