/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.TextResource;
import com.ur.g5.expert.JointZeroingPanel;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.lang.react.RecipeHelper;
import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointType;
import com.ur.swing.ViewContext;
import com.ur.swing.dialog.ConfirmationDialogListener;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.swing.g5.CardBorder;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.view.constants.dev.RobotMode;
import com.ur.view.hmc.ControllerSocketSender;
import gui.tools.DialogCreator;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.Border;
import javax.swing.plaf.metal.MetalToggleButtonUI;

public class JointZeroingSelectionPanel
extends JPanel {
    private static final Dimension NORMAL_BUTTON_SIZE = new Dimension(200, 35);
    private Map<JointType, JToggleButton> jointButtons = new LinkedHashMap<JointType, JToggleButton>();
    private JToggleButton selectAllJointsButton;
    private TextResource textResource;
    private DialogCreator dialogCreator;
    private JointZeroingPanel jointZeroingPanel;
    private JButton zeroJointsButton;
    private final com.ur.i18n.TextResource oldTextResource;
    private final RecipeHelper recipeHelper = new RecipeHelper();

    public JointZeroingSelectionPanel(ViewContext viewContext, DialogCreator dialogCreator, JointZeroingPanel jointZeroingPanel, Recipe<RobotState> robotStateRecipe) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.dialogCreator = dialogCreator;
        this.jointZeroingPanel = jointZeroingPanel;
        this.oldTextResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.initElements();
        this.recipeHelper.add(RobotState.class, robotStateRecipe, (Consumer)new UpdateZeroButtonsListener());
    }

    public void enter() {
        this.selectAllJointsButton.setSelected(false);
        this.selectAllJointsButton.setEnabled(false);
        this.setAllButtonsSelected(false);
        this.zeroJointsButton.setEnabled(false);
        this.recipeHelper.subscribe(RobotState.class);
    }

    public void exit() {
        this.recipeHelper.unsubscribe(RobotState.class);
    }

    private void initElements() {
        this.setBorder((Border)new CardBorder(this.textResource.jointZeroing()));
        this.setLayout(new BoxLayout(this, 1));
        JLabel selectJointLabel = new JLabel("<html><div align=\"center\">" + this.textResource.selectJointsToZero() + "<div></html>", 0);
        selectJointLabel.setAlignmentX(0.5f);
        this.selectAllJointsButton = this.createSelectAllJointButton();
        this.zeroJointsButton = new JButton(this.textResource.zeroJoints());
        this.zeroJointsButton.setEnabled(false);
        this.setButtonSize(this.zeroJointsButton);
        this.add(this.newFiller(1, 10));
        this.add(selectJointLabel);
        this.add(this.newFiller());
        this.add(this.selectAllJointsButton);
        this.add(this.newFiller());
        this.initJointButtons();
        this.add(this.newFiller(1, 50));
        this.add(this.zeroJointsButton);
        this.zeroJointsButton.addActionListener(this.createZeroJointsAction());
    }

    private void setAllButtonsSelected(Boolean isSelected) {
        for (Map.Entry<JointType, JToggleButton> entry : this.jointButtons.entrySet()) {
            JToggleButton button = entry.getValue();
            button.setSelected(isSelected);
        }
    }

    private void setAllJointButtonsEnabled(boolean isEnabled) {
        for (JToggleButton button : this.jointButtons.values()) {
            button.setEnabled(isEnabled);
        }
    }

    private ActionListener createZeroJointsAction() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JointZeroingSelectionPanel.this.okAction();
            }
        };
    }

    private void initJointButtons() {
        this.jointButtons.put(JointType.BASE, new JToggleButton(this.oldTextResource.joint0Name()));
        this.jointButtons.put(JointType.SHOULDER, new JToggleButton(this.oldTextResource.joint1Name()));
        this.jointButtons.put(JointType.ELBOW, new JToggleButton(this.oldTextResource.joint2Name()));
        this.jointButtons.put(JointType.WRIST1, new JToggleButton(this.oldTextResource.joint3Name()));
        this.jointButtons.put(JointType.WRIST2, new JToggleButton(this.oldTextResource.joint4Name()));
        this.jointButtons.put(JointType.WRIST3, new JToggleButton(this.oldTextResource.joint5Name()));
        for (Map.Entry<JointType, JToggleButton> entry : this.jointButtons.entrySet()) {
            JToggleButton button = entry.getValue();
            this.setButtonLayout(button);
            this.addButtonAction(button);
            this.add(this.newFiller());
            this.add(button);
        }
    }

    private void addButtonAction(final JToggleButton button) {
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!button.isSelected()) {
                    JointZeroingSelectionPanel.this.selectAllJointsButton.setSelected(false);
                }
                JointZeroingSelectionPanel.this.zeroJointsButton.setEnabled(JointZeroingSelectionPanel.this.isAnyJointSelected());
            }
        });
    }

    private JToggleButton createSelectAllJointButton() {
        JToggleButton button = new JToggleButton(this.textResource.allJoints());
        this.setButtonLayout(button);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JointZeroingSelectionPanel.this.setAllButtonsSelected(JointZeroingSelectionPanel.this.selectAllJointsButton.isSelected());
                JointZeroingSelectionPanel.this.zeroJointsButton.setEnabled(JointZeroingSelectionPanel.this.isAnyJointSelected());
            }
        });
        return button;
    }

    private void setButtonLayout(JToggleButton button) {
        this.setButtonSize(button);
        button.setUI(new MetalToggleButtonUI(){

            @Override
            protected Color getSelectColor() {
                return G5LookAndFeel.UNIVERSAL_ROBOTS_DARK_BLUE;
            }
        });
    }

    private void setButtonSize(AbstractButton button) {
        button.setMinimumSize(NORMAL_BUTTON_SIZE);
        button.setMaximumSize(NORMAL_BUTTON_SIZE);
        button.setPreferredSize(NORMAL_BUTTON_SIZE);
        button.setAlignmentX(0.5f);
    }

    private Box.Filler newFiller(int width, int height) {
        Dimension minSize = new Dimension(width, height);
        Dimension prefSize = new Dimension(width, height);
        Dimension maxSize = new Dimension(width, height);
        return new Box.Filler(minSize, prefSize, maxSize);
    }

    private Box.Filler newFiller() {
        return this.newFiller(1, 20);
    }

    private void okAction() {
        ConfirmationDialogListener listener = new ConfirmationDialogListener(){

            public void onOkClicked() {
                StringBuilder sb = new StringBuilder();
                for (Map.Entry entry : JointZeroingSelectionPanel.this.jointButtons.entrySet()) {
                    JToggleButton button = (JToggleButton)entry.getValue();
                    if (button.isSelected()) {
                        sb.append("1");
                        continue;
                    }
                    sb.append("0");
                }
                ControllerSocketSender.sendZeroSpecificJoints((String)sb.toString());
                JointZeroingSelectionPanel.this.showSuccesMessage();
            }
        };
        this.confirmZeroJoints(listener);
    }

    private void showSuccesMessage() {
        DialogMessage dialogMessage = new DialogMessage(this.textResource.jointZeroing(), this.textResource.jointsSuccessfullyZeroed());
        DialogListener dialogListener = new DialogListener();
        this.dialogCreator.showMessageDialog(dialogMessage, MessageDialogType.MESSAGE, (OkDialogListener)dialogListener);
    }

    private boolean isAnyJointSelected() {
        if (this.selectAllJointsButton.isSelected()) {
            return true;
        }
        for (Map.Entry<JointType, JToggleButton> entry : this.jointButtons.entrySet()) {
            JToggleButton button = entry.getValue();
            if (!button.isSelected()) continue;
            return true;
        }
        return false;
    }

    private void confirmZeroJoints(ConfirmationDialogListener confirmationDialogListener) {
        ConfirmationMessage message = new ConfirmationMessage(this.textResource.zeroJoints(), this.textResource.confirmJointZeroing(), this.oldTextResource.Yes(), this.oldTextResource.No());
        this.dialogCreator.showConfirmationDialog(message, confirmationDialogListener);
    }

    private class UpdateZeroButtonsListener
    implements Consumer<RobotState> {
        private boolean performUpdateOfUI = true;

        private UpdateZeroButtonsListener() {
        }

        public void accept(RobotState rs) {
            boolean bl = this.performUpdateOfUI = !this.performUpdateOfUI;
            if (this.performUpdateOfUI) {
                boolean okToZero = rs.robotMode == RobotMode.IDLE || rs.robotMode == RobotMode.RUNNING;
                JointZeroingSelectionPanel.this.setAllJointButtonsEnabled(okToZero);
                JointZeroingSelectionPanel.this.selectAllJointsButton.setEnabled(okToZero);
                if (!okToZero) {
                    JointZeroingSelectionPanel.this.zeroJointsButton.setEnabled(false);
                }
            }
        }
    }

    private class DialogListener
    extends OkDialogListener {
        private DialogListener() {
        }

        public void onOkClicked() {
            JointZeroingSelectionPanel.this.jointZeroingPanel.navigateBack();
        }
    }
}

