/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.expert.ExpertLockedPanel;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.swing.flippable.FlippablePanel;
import gui.main.OnScreenFileEditor;
import gui.main.SelectFileContext;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractAction;

public class ShowExpertFileEditor
extends AbstractAction {
    private final PasswordManager passwordManager;
    private final GoToEnterPassword enterPassword;
    private FlippablePanel flipPanel;

    @Inject
    ShowExpertFileEditor(PasswordManager passwordManager, GoToEnterPassword enterPassword) {
        this.passwordManager = passwordManager;
        this.enterPassword = enterPassword;
    }

    public void setFlippablePanel(FlippablePanel flipPanel) {
        this.flipPanel = flipPanel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.requestLogin();
    }

    private void requestLogin() {
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.ADMIN)) {
            this.enterPassword.requestPassword(PasswordManager.Lock.ADMIN, new PasswordLoginListener(){

                public void onLoginSuccess() {
                    ShowExpertFileEditor.this.doSwitchToFileEditor(ShowExpertFileEditor.this.flipPanel);
                }

                public void onLoginFailure() {
                    ShowExpertFileEditor.this.doSwitchToLockedPanel(ShowExpertFileEditor.this.flipPanel);
                }
            });
        } else {
            this.doSwitchToFileEditor(this.flipPanel);
        }
    }

    private void doSwitchToFileEditor(FlippablePanel flipPanel) {
        flipPanel.stackCurrentCardAndSwitchTo(OnScreenFileEditor.class, (Object)SelectFileContext.Configuration);
    }

    private void doSwitchToLockedPanel(FlippablePanel flipPanel) {
        flipPanel.switchTo(ExpertLockedPanel.class, null);
    }
}

