/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.expert;

import com.ur.g5.expert.ExpertTab;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.security.GoToEnterPassword;
import com.ur.polyscope.security.PasswordLoginListener;
import com.ur.polyscope.security.PasswordManager;
import com.ur.swing.FlipManager;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.view.action.ShowExpertScreenAction;
import gui.main.MainPanel;
import gui.polyscope.CalibrationModeService;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

public class ShowExpertScreenActionImpl
extends ShowScreenActionImpl
implements ShowExpertScreenAction {
    private final CalibrationModeService calibrationModeService;
    private final PasswordManager passwordManager;
    private GoToEnterPassword enterPassword;

    @Inject
    ShowExpertScreenActionImpl(CalibrationModeService calibrationModeService, MainPanel mainPanel, PasswordManager passwordManager, GoToEnterPassword enterPassword) {
        super(ExpertTab.class, (FlipManager)mainPanel, true);
        this.calibrationModeService = calibrationModeService;
        this.passwordManager = passwordManager;
        this.enterPassword = enterPassword;
        this.putValue("Name", "Kinematics Calibration");
    }

    public void actionPerformed(ActionEvent e) {
        this.requestLogin();
    }

    private void requestLogin() {
        if (this.passwordManager.isPasswordDefined(PasswordManager.Lock.HARDCODED)) {
            this.enterPassword.requestPassword(PasswordManager.Lock.HARDCODED, new PasswordLoginListener(){

                public void onLoginSuccess() {
                    if (EqualsUtil.equals((Object)ShowExpertScreenActionImpl.this.getValue("SwingSelectedKey"), (Object)true)) {
                        ShowExpertScreenActionImpl.this.calibrationModeService.setMode(CalibrationModeService.CalibrationMode.CALIBRATION_MODE);
                    } else {
                        ShowExpertScreenActionImpl.this.calibrationModeService.setMode(CalibrationModeService.CalibrationMode.NO_CALIBRATION_MODE);
                    }
                    ShowExpertScreenActionImpl.this.doSwitchToExpertScreen();
                }

                public void onLoginFailure() {
                }
            });
        } else {
            this.doSwitchToExpertScreen();
        }
    }

    private void doSwitchToExpertScreen() {
        super.actionPerformed(null);
    }
}

