/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.filemanager;

import com.ur.g5.MenuImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.util.KeyEventsSuppressor;
import com.ur.g5.util.MenuContributionActionDecorator;
import com.ur.lang.ClassUtils;
import com.ur.polyscope.calibration.programcorrection.NotAWaypointCard;
import com.ur.polyscope.calibration.programcorrection.ProgramCorrectionPanel;
import com.ur.polyscope.calibration.programcorrection.ProgramTransKeyPairCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransNodeTab;
import com.ur.polyscope.calibration.programcorrection.ProgramTransProgramCard;
import com.ur.polyscope.calibration.programcorrection.ProgramTransSettingsAndOverviewTab;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.PrivilegeRestriction;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.security.UserAccessState;
import com.ur.program.edit.infrastructure.ProgramFileAction;
import com.ur.program.edit.infrastructure.ProgramFilePersistence;
import com.ur.safety.security.SafetyLock;
import com.ur.security.Privilege;
import com.ur.swing.ActionDefinition;
import com.ur.swing.InterceptableAction;
import com.ur.swing.WidgetFactory;
import com.ur.swing.extensible.MenuExtension;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.event.EventManager;
import com.ur.view.constants.dev.OperationalMode;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.main.MainView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.font.FontRenderContext;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class FileManagerButtonFactory {
    public static final String CREATE_NEW = "fileManager.createNew.FileManagerButtonFactory";
    public static final String OPEN = "fileManager.open.FileManagerButtonFactory";
    public static final String SAVE = "fileManager.save.FileManagerButtonFactory";
    private final TextResource textResource;
    private final WidgetFactory widgetFactory;
    private final EventManager eventManager;
    private final ProgramFilePersistence programFilePersistence;
    private final InstallationFilePersistence installationFilePersistence;
    private final LockActionCreator privilegeDecorator;
    private final Privileges privileges;
    private final MenuContributionActionDecorator menuContributionActionDecorator;
    private final NewButtonRestriction newButtonRestriction;
    private final OpenButtonRestriction openButtonRestriction;
    private final SaveButtonRestriction saveButtonRestriction;

    @Inject
    public FileManagerButtonFactory(TextResource textResource, WidgetFactory widgetFactory, EventManager eventManager, ProgramFilePersistence programFilePersistence, InstallationFilePersistence installationFilePersistence, LockActionCreator privilegeDecorator, Privileges privileges, MenuContributionActionDecorator menuContributionActionDecorator, NewButtonRestriction newButtonRestriction, OpenButtonRestriction openButtonRestriction, SaveButtonRestriction saveButtonRestriction) {
        this.textResource = textResource;
        this.widgetFactory = widgetFactory;
        this.eventManager = eventManager;
        this.programFilePersistence = programFilePersistence;
        this.installationFilePersistence = installationFilePersistence;
        this.privilegeDecorator = privilegeDecorator;
        this.privileges = privileges;
        this.menuContributionActionDecorator = menuContributionActionDecorator;
        this.newButtonRestriction = newButtonRestriction;
        this.openButtonRestriction = openButtonRestriction;
        this.saveButtonRestriction = saveButtonRestriction;
    }

    public JToggleButton createNewButton() {
        FileManagerAction action = new FileManagerAction(this.widgetFactory, this.eventManager, this.programFilePersistence.createNewProgramAction(), this.installationFilePersistence.createNewDefaultInstallation());
        action.putValue("InternalName", CREATE_NEW);
        action.putValue("HelpId", "gui:file_manager_new");
        action.putValue("SmallIcon", MenuImageResource.newFileIconWhite());
        action.putValue("Name", this.textResource.FileNew());
        return this.createToggleButton(action, LockableRestrictedPoint.EDIT_PROGRAM, this.newButtonRestriction);
    }

    public JToggleButton createOpenButton() {
        FileManagerAction action = new FileManagerAction(this.widgetFactory, this.eventManager, this.programFilePersistence.createLoadProgramAction(), this.installationFilePersistence.createLoadInstallation());
        action.putValue("InternalName", OPEN);
        action.putValue("HelpId", "gui:file_manager_open");
        action.putValue("SmallIcon", MenuImageResource.openFileIconWhite());
        action.putValue("Name", this.textResource.FileOpen());
        return this.createToggleButton(action, LockableRestrictedPoint.RUN_PROGRAM, this.openButtonRestriction);
    }

    public JToggleButton createSaveButton() {
        FileManagerAction action = new FileManagerAction(this.widgetFactory, this.eventManager, this.programFilePersistence.createSaveAllAction(), this.programFilePersistence.createSaveAsProgramAction(), this.installationFilePersistence.createSaveAsInstallation());
        action.putValue("InternalName", SAVE);
        action.putValue("HelpId", "gui:file_manager_save");
        action.putValue("SmallIcon", MenuImageResource.saveFileIconWhite());
        action.putValue("Name", this.textResource.FileSave());
        return this.createToggleButton(action, LockableRestrictedPoint.EDIT_PROGRAM, this.saveButtonRestriction);
    }

    private JToggleButton createToggleButton(FileManagerAction action, LockableRestrictedPoint restrictedPoint, PrivilegeRestriction restriction) {
        Privilege restrictedPointPrivilege = this.privileges.getPrivilege((RestrictedPoint)restrictedPoint);
        FileManagerAction decoratedAction = (FileManagerAction)this.privilegeDecorator.lockWithPrivilege((InterceptableAction)action, restrictedPointPrivilege);
        Action buttonAction = this.menuContributionActionDecorator.applyRestrictions((Action)((Object)decoratedAction), restriction);
        JToggleButton button = this.widgetFactory.createToggleButton(buttonAction);
        action.setPopupMenuButton(button);
        this.menuContributionActionDecorator.addFamilyMember(action);
        return button;
    }

    private static class SaveButtonRestriction
    extends AbstractButtonRestriction {
        @Inject
        SaveButtonRestriction(MainView mainPanel, SafetyLock safetyLock) {
            super(mainPanel, safetyLock);
        }

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            return userAccessState.getOperationalMode() == OperationalMode.AUTOMATIC || this.isProgramCorrectionTabSelected() || super.isRestrictedIn(userAccessState);
        }

        private boolean isProgramCorrectionTabSelected() {
            return ClassUtils.isAssignableFromAny(this.mainPanel.getCurrentCard().getClass(), (Class[])new Class[]{ProgramCorrectionPanel.class, ProgramTransSettingsAndOverviewTab.class, ProgramTransNodeTab.class, ProgramTransProgramCard.class, NotAWaypointCard.class, ProgramTransKeyPairCard.class});
        }
    }

    private static class OpenButtonRestriction
    extends AbstractButtonRestriction {
        @Inject
        OpenButtonRestriction(MainView mainPanel, SafetyLock safetyLock) {
            super(mainPanel, safetyLock);
        }
    }

    private static class NewButtonRestriction
    extends AbstractButtonRestriction {
        private final ProgramModeHolder programModeHolder;

        @Inject
        NewButtonRestriction(MainView mainPanel, ProgramModeHolder programModeHolder, SafetyLock safetyLock) {
            super(mainPanel, safetyLock);
            this.programModeHolder = programModeHolder;
        }

        @Override
        public boolean isRestrictedIn(UserAccessState userAccessState) {
            return userAccessState.getOperationalMode() == OperationalMode.AUTOMATIC || this.programModeHolder.getMode() == ProgramModeHolder.ProgramMode.Calibration || super.isRestrictedIn(userAccessState);
        }
    }

    private static abstract class AbstractButtonRestriction
    implements PrivilegeRestriction {
        protected final MainView mainPanel;
        private final SafetyLock safetyLock;

        @Inject
        AbstractButtonRestriction(MainView mainPanel, SafetyLock safetyLock) {
            this.mainPanel = mainPanel;
            this.safetyLock = safetyLock;
        }

        public boolean isRestrictedIn(UserAccessState userAccessState) {
            return !this.safetyLock.isLocked() || !this.mainPanel.getSwitchSupport().isAllCardStacksEmpty();
        }
    }

    private static class FileManagerAction
    extends ProgramFileAction
    implements MenuExtension.OverlayAction,
    ProgramModeHolder.ProgramModeListener {
        private final JPopupMenu popupMenu = new JPopupMenu();
        private AbstractButton button;
        private final Timer refreshTimer = new Timer(100, e -> {
            this.popupMenu.revalidate();
            this.popupMenu.repaint();
        });

        FileManagerAction(WidgetFactory widgetFactory, EventManager eventManager, Action ... actions) {
            this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
            this.notifyOverlayEnabled(false);
            for (Action action : actions) {
                JMenuItem menuButton = widgetFactory.createMenuButton(action);
                int desiredWidth = FileManagerAction.getDesiredWidth(action, menuButton) + 35;
                menuButton.setPreferredSize(new Dimension(Math.max(200, desiredWidth), 45));
                this.popupMenu.add(menuButton);
            }
            this.popupMenu.pack();
            eventManager.addStrongListener(ProgramModeHolder.ProgramModeListener.class, (Object)this);
        }

        private static int getDesiredWidth(Action action, JMenuItem menuButton) {
            Object antiAliasHint = RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT;
            Object fractionalMetricsHint = RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT;
            FontRenderContext fontRenderContext = new FontRenderContext(null, antiAliasHint, fractionalMetricsHint);
            return (int)menuButton.getFont().getStringBounds((String)action.getValue("Name"), fontRenderContext).getWidth();
        }

        public void changedMode(ProgramModeHolder.ProgramMode newMode) {
            if (!this.isEnabled()) {
                return;
            }
            if (newMode == ProgramModeHolder.ProgramMode.Calibration) {
                this.setColor(G5LookAndFeel.HEADER_BACKGROUND);
            } else {
                this.setColor(G5LookAndFeel.SELECTED_HEADER_BACKGROUND);
            }
        }

        private void setColor(Color color) {
            for (Component component : this.popupMenu.getComponents()) {
                if (!(component instanceof JMenuItem)) continue;
                component.setBackground(color);
            }
            this.popupMenu.setBorder(BorderFactory.createLineBorder(color, 2));
        }

        public void doActionPerformed(ActionEvent e) {
            if (!this.button.isEnabled() || !this.popupMenu.isEnabled()) {
                return;
            }
            if (!this.popupMenu.isVisible()) {
                this.popupMenu.show(this.button, this.button.getWidth() - this.popupMenu.getPreferredSize().width, this.button.getHeight());
                this.refreshTimer.start();
            }
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.notifyOverlayEnabled(true);
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            this.notifyOverlayEnabled(false);
            this.button.setSelected(false);
            this.refreshTimer.stop();
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
            this.notifyOverlayEnabled(false);
        }

        void setPopupMenuButton(AbstractButton button) {
            this.button = button;
            button.addKeyListener(new KeyEventsSuppressor());
            this.popupMenu.addPopupMenuListener((PopupMenuListener)((Object)this));
        }

        public void putValue(String key, Object value) {
            super.putValue(key, value);
            if ("InternalName".equals(key)) {
                this.popupMenu.setName(value + ".popup");
            }
        }

        public void notifyOverlayEnabled(boolean enabled) {
            this.putValue("overlayEnabled", enabled);
        }

        public boolean isOverlayEnabled() {
            return (Boolean)this.getValue("overlayEnabled");
        }

        public boolean isRestrictive() {
            return false;
        }
    }
}

