/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation;

import com.ur.g5.installation.InstallationTab;
import com.ur.i18n.TextResource;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.payload.PayloadService;
import com.ur.polyscope.payload.common.InstallationPayloadComponent;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.polyscope.valueobjects.Weight;
import com.ur.resources.ViewImageResource;
import com.ur.safety.workpiece.domain.WorkpieceLookup;
import com.ur.swing.ActionDefinition;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.card.ShowIconListener;
import com.ur.swing.extensible.Extension;
import com.ur.swing.extensible.MenuExtension;
import com.ur.util.event.EventManager;
import gui.main.MainView;
import java.awt.Component;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;

@Extension(value="HeaderMenu")
@Singleton
public class InstallationMenuExtension
extends ShowScreenActionImpl
implements MenuExtension,
ShowIconListener,
PostSetInstallation {
    private static final String INSTALLATION_SCREEN = "installationScreen.HeaderMenu";
    private final TextResource textResource;
    private final LockActionCreator actionForPrivilegeDecorator;
    private final Privileges privilegeSite;
    private final Set<Component> componentsWithIcon = new HashSet<Component>();
    private final PayloadService payloadService;
    private final WorkpieceLookup workpieceLookup;

    @Inject
    public InstallationMenuExtension(Privileges privilegeSite, TextResource textResource, LockActionCreator actionForPrivilegeDecorator, MainView flipManager, EventManager eventManager, PayloadService payloadService, WorkpieceLookup workpieceLookup) {
        super(InstallationTab.class, (FlipManager)flipManager);
        this.privilegeSite = privilegeSite;
        this.textResource = textResource;
        this.actionForPrivilegeDecorator = actionForPrivilegeDecorator;
        this.payloadService = payloadService;
        this.workpieceLookup = workpieceLookup;
        eventManager.addStrongListener(ShowIconListener.class, (Object)this);
    }

    public MenuExtension.MenuContribution create() {
        this.putValue("Name", this.textResource.tabInstallation());
        this.putValue("SmallIcon", ViewImageResource.installationWhite());
        this.putValue("Function", ActionDefinition.Function.APPLICATION_HEADER);
        this.putValue("InternalName", INSTALLATION_SCREEN);
        this.putValue("HelpId", "gui:installation");
        this.updateForPayloadChange(this.hasRequiredConfigurationBeenSet());
        InterceptableAction restrictedAction = this.actionForPrivilegeDecorator.lockWithPrivilege((InterceptableAction)this, this.privilegeSite.getPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION));
        return MenuExtension.MenuContribution.locateAfter((int)1000, (MenuExtension.MenuContribution)new MenuExtension.MenuContribution((Action)restrictedAction, "navigation"));
    }

    private boolean hasRequiredConfigurationBeenSet() {
        return this.isPayloadSet() && this.workpieceLookup.isToolsDefined();
    }

    private boolean isPayloadSet() {
        InstallationPayloadComponent installationDefaultPayload = this.payloadService.getInstallationDefaultPayload();
        Weight weight = Objects.nonNull(installationDefaultPayload) ? this.payloadService.getInstallationDefaultPayload().getMass() : null;
        return !Weight.ZERO.equals((Object)weight);
    }

    private boolean isEmptyIcon(Icon icon) {
        return icon instanceof ImageIcon && ((ImageIcon)icon).getDescription().contains("blank");
    }

    public void setIcon(Component component, Icon icon) {
        if (this.getFlipManager().getCurrentCard().getClass() == this.getDestinationPanelType()) {
            if (this.isEmptyIcon(icon)) {
                this.componentsWithIcon.remove(component);
            } else {
                this.componentsWithIcon.add(component);
            }
            this.updateForPayloadChange(this.hasRequiredConfigurationBeenSet());
        }
    }

    private void updateForPayloadChange(boolean requiredConfigurationSet) {
        boolean disableWarning = Boolean.parseBoolean(System.getProperty("com.ur.polyscope.disableheaderwarnings", "false"));
        this.putValue("SmallIcon", requiredConfigurationSet || disableWarning ? ViewImageResource.installationWhite() : ViewImageResource.installationWhiteWarning());
    }

    public void postLoad(Installation installation) {
        this.updateForPayloadChange(this.hasRequiredConfigurationBeenSet());
        this.componentsWithIcon.clear();
    }
}

