/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation;

import com.ur.g5.TextResource;
import com.ur.g5.installation.SafetyTabNavigationEventImpl;
import com.ur.g5.installation.menu.InstallationMenuBuilder;
import com.ur.injection.Builder;
import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationNode;
import com.ur.polyscope.installation.InstallationNodeInfo;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.menu.InstallationMenuCategory;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory;
import com.ur.polyscope.viewfacade.installation.ProfinetNotDisabledTooltip;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.SafetyTabNavigationEvent;
import com.ur.resources.ViewImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CardPanel;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FlipManager;
import com.ur.swing.MouseEventActionWrapper;
import com.ur.swing.ShowScreenAction;
import com.ur.swing.ShowScreenActionImpl;
import com.ur.swing.SwingUtil;
import com.ur.swing.ViewContext;
import com.ur.swing.baseview.AccordionView;
import com.ur.swing.baseview.BaseAccordionView;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.urcap.api.contribution.InstallationNodeContribution;
import com.ur.urcap.contribution.installation.URCapInstallation;
import com.ur.util.event.EventManager;
import com.ur.util.event.EventNotificationService;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.Settings;
import com.ur.view.polyscope.module.UIInstallationNode;
import com.ur.view.polyscope.module.installation.InstallationContributionsProvider;
import gui.installation.ContributionStateListener;
import gui.polyscope.InstallationTreeSelector;
import gui.polyscope.setup.RobotMountingTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.java.balloontip.BalloonTip;

@Singleton
public class InstallationTab
extends CardPanel
implements InstallationTreeSelector,
ProfinetNotDisabledTooltip {
    public static final String GENERAL_TAB = "generalTab.G5InstallationTab";
    public static final String MOTION_TAB = "generalTab.G5MotionTab";
    public static final String FEATURES_TAB = "featuresTab.G5InstallationTab";
    public static final String CONVEYOR = "ConveyorTracking";
    public static final String SAFETY_TAB = "safetyTab.G5InstallationTab";
    public static final String FIELD_BUS_TAB = "fieldbusTab.G5InstallationTab";
    private final BaseAccordionView navigation;
    private final FlippablePanel flippablePanel;
    private final ViewContext view;
    private final InstallationContributionsProvider contributionsProvider;
    private final InstallationMenuBuilder installationMenu;
    private final InstallationTabErrorInfo errorInfo = new InstallationTabErrorInfo();
    private final ErrorablePanel safetyErrorablePanel;
    private boolean firstEnter = true;
    protected BindingRegistration messageRegistration = BindingRegistration.NULL_REGISTRATION;

    @Inject
    public InstallationTab(Builder builder, ViewContext view, InstallationContributionsProvider contributionsProvider, EventManager eventManager, InstallationMenuBuilder installationMenu, ErrorablePanel errorablePanel, UserAccessControl userAccessControl) {
        this.view = view;
        this.contributionsProvider = contributionsProvider;
        this.installationMenu = installationMenu;
        this.safetyErrorablePanel = errorablePanel;
        this.addSafetyNavigationListener(eventManager, userAccessControl);
        this.flippablePanel = new FlippablePanel();
        this.flippablePanel.setCardParent((CardPanel)this);
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createMatteBorder(5, 5, 5, 5, G5LookAndFeel.BETWEEN_CARD_COLOR));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.navigation = (BaseAccordionView)builder.get(BaseAccordionView.class);
        this.navigation.setLanguage(Settings.getLanguage());
        installationMenu.setNavigationMenu((AccordionView)this.navigation);
        installationMenu.setHeaderAddedListener(contribution -> {
            if (!(contribution.contribution instanceof ShowScreenAction)) {
                return;
            }
            ShowScreenAction showScreenAction = (ShowScreenAction)contribution.contribution;
            this.flippablePanel.addCardPanel((CardPanel)builder.get(showScreenAction.getDestinationPanelType()));
            try {
                ((ShowScreenActionImpl)showScreenAction).setFlipManager((FlipManager)this.flippablePanel);
            }
            catch (Exception e) {
                Log.warning((String)"Failed to set flipManager", (Throwable)e);
            }
        });
        installationMenu.setItemAddedListener(contribution -> {
            if (contribution.contribution instanceof ContributedNodeAction) {
                this.errorInfo.registerNode((ContributedNodeAction)((Object)((Object)contribution.contribution)));
                return;
            }
            if (!(contribution.contribution instanceof ShowScreenAction)) {
                return;
            }
            ErrorablePanel flipManager = contribution.getMenuCategory() == InstallationMenuCategory.SAFETY ? this.safetyErrorablePanel : this.flippablePanel;
            ShowScreenAction showScreenAction = (ShowScreenAction)contribution.contribution;
            this.errorInfo.registerAction((Action)showScreenAction);
            flipManager.addCardPanel(this.errorInfo.registerNode((CardPanel)builder.get(showScreenAction.getDestinationPanelType())));
            try {
                ((ShowScreenActionImpl)showScreenAction).setFlipManager((FlipManager)flipManager);
            }
            catch (Exception e) {
                Log.warning((String)"Failed to set flipManager", (Throwable)e);
            }
        });
        Map<InstallationMenuCategory, List<Action>> menuContributions = this.getMenuContributionsByType();
        installationMenu.setMenuContributions(menuContributions);
        installationMenu.addSpecialContributions(InstallationMenuCategory.GENERAL, this.flippablePanel, this::updateGUINodesErrorState, CONVEYOR);
        this.add((Component)this.navigation, "West");
        this.add((Component)this.flippablePanel, "Center");
        contributionsProvider.registerCardPanels((FlipManager)this.flippablePanel);
        eventManager.addStrongListener(InstallationStateListener.class, (Object)new InstallationStateListener.Template(){

            public void installationLoaded(Installation installation) {
                SwingUtil.invokeLater(this::updateInstallationMenuInParent);
            }

            private void updateInstallationMenuInParent() {
                InstallationTab.this.updateInstallationMenu(false);
            }

            public void installationModified() {
                InstallationTab.this.updateGUINodesErrorState();
            }
        });
        eventManager.addStrongListener(ContributionStateListener.class, (Object)new ContributionStateListener.Adapter(){

            public void contributionModified() {
                SwingUtil.invokeLater(this::updateInstallationMenuInParent);
            }

            private void updateInstallationMenuInParent() {
                InstallationTab.this.updateInstallationMenu(true);
            }
        });
    }

    private void addSafetyNavigationListener(EventManager eventManager, UserAccessControl userAccessControl) {
        SafetyTabNavigationEventImpl safetyTabNavigationEvent = new SafetyTabNavigationEventImpl(this, userAccessControl);
        eventManager.addStrongListener(SafetyTabNavigationEvent.class, (Object)safetyTabNavigationEvent);
    }

    private void updateInstallationMenu(boolean contributionWasModified) {
        Action selected = this.navigation.getSelected();
        boolean wasURCapNodeSelected = selected instanceof ContributedNodeAction;
        boolean haveURCaps = this.installationMenu.updateURCapContributions(this.flippablePanel, this.errorInfo, this::updateGUINodesErrorState, CONVEYOR);
        this.updateGUINodesErrorState();
        if (wasURCapNodeSelected) {
            if (haveURCaps) {
                if (contributionWasModified) {
                    this.navigation.selectTopSection(this.installationMenu.getNavigationButton(InstallationMenuCategory.URCAPS));
                } else {
                    this.selectTreeNode(((ContributedNodeAction)((Object)selected)).getInstallationNode());
                }
            } else {
                this.navigation.resetNavigation();
            }
        }
        this.navigation.revalidate();
        this.navigation.repaint();
    }

    private Map<InstallationMenuCategory, List<Action>> getMenuContributionsByType() {
        EnumMap<InstallationMenuCategory, List<Action>> result = new EnumMap<InstallationMenuCategory, List<Action>>(InstallationMenuCategory.class);
        for (UIInstallationNode node : this.contributionsProvider.getUIInstallationNodes()) {
            InstallationNodeContribution userContribution;
            if (!(node.getInstallation() instanceof URCapInstallation) || !((userContribution = ((URCapInstallation)node.getInstallation()).getInstallationContribution().getUserContribution()) instanceof com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory)) continue;
            com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory menuContribution = (com.ur.polyscope.urcaps.extensions.installationnodecontribution.menu.InstallationMenuCategory)userContribution;
            List actions = result.computeIfAbsent(this.urcapMenuToInstallationMenuCategory(menuContribution.getInstallationMenu()), k -> new ArrayList());
            actions.add(this.errorInfo.registerNode(new ContributedNodeAction(this.flippablePanel, this.contributionsProvider, node, this::updateGUINodesErrorState)));
        }
        return result;
    }

    private InstallationMenuCategory urcapMenuToInstallationMenuCategory(InstallationMenuCategory.InstallationMenu urcapMenu) {
        switch (urcapMenu) {
            default: {
                return InstallationMenuCategory.GENERAL;
            }
            case SAFETY: {
                return InstallationMenuCategory.SAFETY;
            }
            case FEATURES: {
                return InstallationMenuCategory.FEATURES;
            }
            case FIELDBUS: 
        }
        return InstallationMenuCategory.FIELDBUS;
    }

    public Class<? extends CardPanel> getPanelClass() {
        return InstallationTab.class;
    }

    public void revalidateTree() {
        this.updateGUINodesErrorState();
    }

    public void selectTreeNode(Class<?> cardTypeToSelect) {
    }

    public void selectTreeNode(InstallationNode installationNode) {
        if (installationNode != null) {
            SectionLocator selectionLocator = new SectionLocator(installationNode);
            this.navigation.selectSection((FlipManager)this.flippablePanel, (BaseAccordionView.ComponentRelation)selectionLocator);
        } else {
            Log.warning((String)"Couldn't select anything appropriate for installation error indication");
        }
    }

    public void selectTreeNode(Action actionToSelect) {
        SectionLocator sectionLocator = new SectionLocator(actionToSelect);
        this.navigation.selectSection((FlipManager)this.flippablePanel, (BaseAccordionView.ComponentRelation)sectionLocator);
    }

    public void enter(Object o) {
        super.enter(o);
        if (this.firstEnter) {
            this.installationMenu.updateURCapContributions(this.flippablePanel, this.errorInfo, this::updateGUINodesErrorState, CONVEYOR);
            this.navigation.resetNavigation();
            this.firstEnter = false;
        } else {
            Object userObject = this.fetchUserObjectFromCurrentAction();
            Class switchToType = this.contributionsProvider.getCardTypeFrom(userObject);
            Object o1 = switchToType == null ? null : userObject;
            this.flippablePanel.enterActiveChild(o1);
        }
        this.updateGUINodesErrorState();
    }

    private Object fetchUserObjectFromCurrentAction() {
        CardPanel userObject = this.flippablePanel.getCurrentCard();
        Action action = this.navigation.getSelected();
        if (action instanceof MouseEventActionWrapper) {
            action = ((MouseEventActionWrapper)action).getWrappedAction();
        }
        if (action instanceof ContributedNodeAction) {
            userObject = ((ContributedNodeAction)((Object)action)).getInstallationNode();
        }
        return userObject;
    }

    public Object exit() {
        Log.trace((String)"Removing all vetoes for Installation Tab");
        EventNotificationService.notify(VetoListener.class, listener -> listener.cancelVeto(RobotMountingTab.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES));
        this.flippablePanel.exitActiveChild();
        return super.exit();
    }

    private void updateGUINodesErrorState() {
        this.errorInfo.updateNodesState();
    }

    @IgnoreProgramChanges
    public void showCardForSafety(Errorable errorable) {
        this.navigation.selectTopSection(this.installationMenu.getNavigationButton(InstallationMenuCategory.SAFETY));
        CardPanel safetyCard = (CardPanel)errorable;
        this.safetyErrorablePanel.switchTo(safetyCard.getClass());
    }

    BaseAccordionView getNavigation() {
        return this.navigation;
    }

    FlippablePanel getMainPanel() {
        return this.flippablePanel;
    }

    public void showProfinetNotDisabledTooltip() {
        this.messageRegistration.removeRegistration();
        this.messageRegistration = DisplayMessageFactory.informCloseAnyClick((JComponent)this.installationMenu.getNavigationButton(InstallationMenuCategory.FIELDBUS), (String)((TextResource)this.view.getTextResource(TextResource.class)).ProfisafeDisabledProfinetStillRunning(), (BalloonTip.AttachLocation)BalloonTip.AttachLocation.EAST, (Dimension)new Dimension(), null);
    }

    private static class SectionLocator
    implements BaseAccordionView.ComponentRelation {
        private Object targetNode;
        private Object targetObject;

        SectionLocator(InstallationNode targetNode) {
            this.targetNode = targetNode;
        }

        SectionLocator(Action targetAction) {
            this.targetNode = targetAction;
        }

        public Object getTargetObject() {
            return this.targetObject;
        }

        public boolean sameLeaf(Component component) {
            if (component instanceof AbstractButton) {
                AbstractButton button = (AbstractButton)component;
                Action action = button.getAction();
                if (action instanceof ContributedNodeAction) {
                    ContributedNodeAction contributedNodeAction = (ContributedNodeAction)((Object)action);
                    InstallationNode installationNode = contributedNodeAction.getInstallationNode();
                    if (this.targetNode == installationNode && this.targetObject == null) {
                        this.targetObject = action;
                        return true;
                    }
                } else if (this.targetNode == action) {
                    this.targetObject = action;
                    return true;
                }
            }
            return false;
        }
    }

    public static class InstallationTabErrorInfo {
        private final List<InstallationNodeInfo> nodes = new ArrayList<InstallationNodeInfo>();
        private final List<Action> actions = new ArrayList<Action>();

        InstallationTabErrorInfo() {
        }

        public ContributedNodeAction registerNode(ContributedNodeAction node) {
            this.nodes.add(node);
            return node;
        }

        public CardPanel registerNode(CardPanel cardPanel) {
            if (cardPanel instanceof InstallationNodeInfo) {
                this.nodes.add((InstallationNodeInfo)cardPanel);
            }
            return cardPanel;
        }

        public void registerAction(Action action) {
            this.actions.add(action);
        }

        public Action lookupActionByCardPanel(CardPanel cardPanel) {
            for (Action action : this.getActions()) {
                ShowScreenAction showScreenAction;
                if (!(action instanceof ShowScreenAction) || !(showScreenAction = (ShowScreenAction)action).getDestinationPanelType().equals(cardPanel.getClass())) continue;
                return showScreenAction;
            }
            return null;
        }

        public void updateNodesState() {
            for (InstallationNodeInfo installationNodeInfo : this.getNodes()) {
                Object action = null;
                if (installationNodeInfo instanceof ContributedNodeAction) {
                    action = (ContributedNodeAction)installationNodeInfo;
                } else if (installationNodeInfo instanceof CardPanel) {
                    action = this.lookupActionByCardPanel((CardPanel)installationNodeInfo);
                }
                if (action == null) continue;
                Icon nodeIcon = this.getIconByNodeInfo(installationNodeInfo);
                action.putValue("SmallIcon", nodeIcon);
            }
        }

        private Icon getIconByNodeInfo(InstallationNodeInfo nodeInfo) {
            ContributedNodeAction actionNode;
            Icon imageResource = null;
            if (nodeInfo.getInstallationNode().hasError()) {
                imageResource = ViewImageResource.formError();
            } else if (nodeInfo instanceof ContributedNodeAction && (actionNode = (ContributedNodeAction)nodeInfo).hasWarning()) {
                imageResource = ViewImageResource.formDeveloperWarning();
            }
            return imageResource;
        }

        List<InstallationNodeInfo> getNodes() {
            return new ArrayList<InstallationNodeInfo>(this.nodes);
        }

        List<Action> getActions() {
            return new ArrayList<Action>(this.actions);
        }
    }

    public static class ContributedNodeAction
    extends AbstractActionDefinition
    implements InstallationNodeInfo {
        private final FlippablePanel flippablePanel;
        private final InstallationContributionsProvider contributionsProvider;
        private final UIInstallationNode treeNode;
        private final Runnable updateUI;

        public ContributedNodeAction(FlippablePanel flippablePanel, InstallationContributionsProvider contributionsProvider, UIInstallationNode treeNode, Runnable updateUI) {
            this.flippablePanel = flippablePanel;
            this.contributionsProvider = contributionsProvider;
            this.treeNode = treeNode;
            this.updateUI = updateUI;
            this.putValue("Name", HTML.unHtml((String)treeNode.toString()));
            this.putValue("InternalName", treeNode.getId());
        }

        public void actionPerformed(ActionEvent e) {
            Object userObject = this.treeNode.getUserObject();
            if (this.flippablePanel.getCurrentCard().getClass() != this.contributionsProvider.getCardTypeFrom(userObject)) {
                this.flippablePanel.switchTo(this.contributionsProvider.getCardTypeFrom(userObject), userObject);
            } else {
                this.flippablePanel.getCurrentCard().exit();
                this.flippablePanel.getCurrentCard().enter(userObject);
            }
            this.putValue("SwingSelectedKey", true);
            this.updateUI.run();
        }

        public InstallationNode getInstallationNode() {
            return ((InstallationNodeInfo)this.treeNode).getInstallationNode();
        }

        public boolean hasWarning() {
            return this.treeNode.hasWarning();
        }
    }
}

