/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation;

import com.ur.disk.Directories;
import com.ur.g5.installation.NavigateToInstallationTab;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.viewfacade.safety.RobotInstallationPersistenceService;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.urcap.contribution.installation.CreationContextListener;
import com.ur.util.event.EventManager;
import com.ur.util.persist.FileUtils;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.NewInstallationCreator;
import gui.polyscope.setup.RequestCreationTypeFromUser;
import java.io.File;
import java.util.Set;
import javax.inject.Inject;

public class NewInstallationCreatorImpl
extends NewInstallationCreator {
    private static final String INSTALLATION_EXTENSION = ".installation";
    private final RobotInstallationLookupService lookupService;
    private final RobotInstallationPersistenceService persistenceService;
    private final EventManager eventManager;
    private final SafetySettingsComparator safetySettingsComparator;
    private final NavigateToInstallationTab flipToInstallationTab;

    @Inject
    public NewInstallationCreatorImpl(RobotInstallationLookupService lookupService, RobotInstallationPersistenceService persistenceService, EventManager eventManager, SafetySettingsComparator safetySettingsComparator, NavigateToInstallationTab flipToInstallationTab, RequestCreationTypeFromUser requestCreationTypeFromUser) {
        super(requestCreationTypeFromUser);
        this.lookupService = lookupService;
        this.persistenceService = persistenceService;
        this.eventManager = eventManager;
        this.safetySettingsComparator = safetySettingsComparator;
        this.flipToInstallationTab = flipToInstallationTab;
    }

    protected void createNewInstallation() {
        this.eventManager.fireEvent(CreationContextListener.class, CreationContextListener::newAndReset);
        this.switchToInstallationTabForVetoListenersHack();
        this.lookupService.createDefaultInstallation(NewInstallationCreatorImpl.getNextAvailableFileName());
    }

    protected void createNewInstallationWithCurrentSafety() {
        this.eventManager.fireEvent(CreationContextListener.class, CreationContextListener::newAndKeep);
        this.switchToInstallationTabForVetoListenersHack();
        Set installationComponents = this.safetySettingsComparator.createInstallationComponentsWithExistingSafety((InstallationComponentLookup)this.lookupService);
        this.lookupService.createDefaultInstallation(NewInstallationCreatorImpl.getNextAvailableFileName(), installationComponents);
        this.persistenceService.save(this.lookupService.getInstallation());
    }

    private void switchToInstallationTabForVetoListenersHack() {
        this.flipToInstallationTab.flipToInstallationTab();
    }

    private static String getNextAvailableFileName() {
        return FileUtils.getNextAvailableFileName((File)Directories.programs(), (String)"default", (String)INSTALLATION_EXTENSION);
    }
}

