/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation;

import com.ur.g5.installation.InstallationTab;
import com.ur.polyscope.security.UserAccessControl;
import com.ur.polyscope.viewfacade.lang.Errorable;
import com.ur.polyscope.viewfacade.safety.SafetyTabNavigationEvent;
import com.ur.swing.CardPanel;
import com.ur.view.constants.dev.OperationalMode;
import java.util.Optional;

public class SafetyTabNavigationEventImpl
implements SafetyTabNavigationEvent {
    private final InstallationTab installationTab;
    private final UserAccessControl userAccessControl;

    public SafetyTabNavigationEventImpl(InstallationTab installationTab, UserAccessControl userAccessControl) {
        this.installationTab = installationTab;
        this.userAccessControl = userAccessControl;
    }

    public void navigateToTab(Errorable errorable) {
        if (this.isInAutomaticMode()) {
            return;
        }
        this.navigateBack();
        this.installationTab.switchTo(InstallationTab.class);
        this.installationTab.showCardForSafety(errorable);
    }

    private boolean isInAutomaticMode() {
        return this.userAccessControl.getCurrentOperationalMode() == OperationalMode.AUTOMATIC;
    }

    private void navigateBack() {
        Optional<CardPanel> currentCard = Optional.ofNullable(this.installationTab.getFlipManager().getCurrentCard());
        currentCard.ifPresent(CardPanel::navigateBack);
    }
}

