/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.action;

import com.ur.polyscope.initializerobot.veto.VetoListener;
import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.swing.FlipManager;
import com.ur.swing.InterceptableAction;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import com.ur.view.installation.QueryUserWhenLoading;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.polyscope.DashBoard;
import gui.program.FileManagementProgramComponent;
import gui.program.ProgramRootNode;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.URFileUtils;
import java.io.File;

public abstract class AbstractInstallationAction
extends InterceptableAction.Default
implements QueryUserWhenLoading {
    private final RobotInstallationSite installationSite;
    protected final DialogCreator dialogCreator;

    AbstractInstallationAction(RobotInstallationSite installationSite, DialogCreator dialogCreator) {
        this.installationSite = installationSite;
        this.dialogCreator = dialogCreator;
    }

    protected void setupVetosOfScreenStacks() {
        EventNotificationService.notify(VetoListener.class, (NotificationStrategy)new NotifyOnVeto());
    }

    public boolean askToApplySafety() {
        DialogReturnValue result = LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)LanguagePack.getConfirmationMessages().confirmApplySafetySettingsOrCancel());
        return result != DialogReturnValue.CANCEL;
    }

    public void askToUseInstallationInCurrentProgram() {
        ProgramRootNode currentProgram = DashBoard.getProgram();
        if (currentProgram != null) {
            File currentInstallationFile;
            Installation installation = this.installationSite.getInstallation();
            FileManagementProgramComponent fileManagementProgramComponent = (FileManagementProgramComponent)currentProgram.getComponent(FileManagementProgramComponent.class);
            PersistanceMetaData persistanceMetaData = (PersistanceMetaData)installation.getMetaData(PersistanceMetaData.class);
            File installationFile = persistanceMetaData.fileWithoutExtension();
            if (!URFileUtils.areFilesCanonicallyEqual((File)installationFile, (File)(currentInstallationFile = new File(fileManagementProgramComponent.getInstallationDirectory(), fileManagementProgramComponent.getInstallationFileName()))) && !new File(fileManagementProgramComponent.getProgramDirectory(), fileManagementProgramComponent.getInstallationRelativePath()).getPath().equals(installationFile.getPath())) {
                String prgInstallFileName = URFileUtils.getRelativeToCanonicalProgramPath((String)fileManagementProgramComponent.getInstallationDirectory(), (String)fileManagementProgramComponent.getInstallationFileName());
                String currentInstallFileName = URFileUtils.getRelativeToProgramPath((String)persistanceMetaData.directory(), (String)persistanceMetaData.fileName());
                ConfirmationMessage message = LanguagePack.getConfirmationMessages().confirmSetDefaultInstallationOrUseItForNow(prgInstallFileName, currentInstallFileName);
                if (this.dialogCreator.showConfirmationDialog(message) == DialogReturnValue.OK) {
                    fileManagementProgramComponent.setInstallationFileName(persistanceMetaData.fileName());
                    fileManagementProgramComponent.setInstallationDirectory(persistanceMetaData.directory());
                } else {
                    fileManagementProgramComponent.setAcceptToRunProgramWithDifferentInstallationLoaded();
                }
            }
        }
    }

    public boolean askUserToResolveSafetyErrors() {
        DialogReturnValue result = LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)LanguagePack.getConfirmationMessages().confirmResolveSafetyErrorsOrCancel());
        return result != DialogReturnValue.CANCEL;
    }

    protected boolean askUserToSaveUnsavedChanges(ConfirmationMessage message) {
        return !this.installationSite.hasModifications() || this.dialogCreator.showConfirmationDialog(message) == DialogReturnValue.OK;
    }

    public FlipManager getFlipManager() {
        return InstallationFilePersistence.getFlipManager();
    }

    public void setFlipManager(FlipManager flipManager) {
        InstallationFilePersistence.setFlipManager((FlipManager)flipManager);
    }

    private static class NotifyOnVeto
    implements NotificationStrategy<VetoListener> {
        private NotifyOnVeto() {
        }

        public void notify(VetoListener listener) {
            listener.veto(AbstractInstallationAction.class, VetoListener.VetoType.ROBOTMODE_CHANGE_MESSAGES);
        }
    }
}

