/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.action;

import com.ur.g5.installation.action.AbstractInstallationAction;
import com.ur.g5.installation.action.LoadInstallationAction;
import com.ur.g5.installation.action.NewInstallationAction;
import com.ur.g5.installation.action.SaveAsInstallationAction;
import com.ur.injection.Builder;
import com.ur.polyscope.security.LockActionCreator;
import com.ur.polyscope.security.LockableRestrictedPoint;
import com.ur.polyscope.security.Privileges;
import com.ur.polyscope.security.RestrictedPoint;
import com.ur.security.Privilege;
import com.ur.swing.InterceptableAction;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import javax.inject.Inject;
import javax.swing.Action;

public class InstallationFilePersistenceImpl
extends InstallationFilePersistence {
    private final Builder builder;
    private final LockActionCreator privilegeDecorator;
    private final Privileges privileges;

    @Inject
    public InstallationFilePersistenceImpl(Builder builder, LockActionCreator privilegeDecorator, Privileges privileges) {
        this.builder = builder;
        this.privilegeDecorator = privilegeDecorator;
        this.privileges = privileges;
    }

    public Action createLoadInstallation() {
        return this.decorateInstallationFileAction(LoadInstallationAction.class);
    }

    public Action createNewDefaultInstallation() {
        return this.decorateInstallationFileAction(NewInstallationAction.class);
    }

    public Action createSaveAsInstallation() {
        return this.decorateInstallationFileAction(SaveAsInstallationAction.class);
    }

    private Action decorateInstallationFileAction(Class<? extends AbstractInstallationAction> actionClass) {
        InterceptableAction action = (InterceptableAction)this.builder.get(actionClass);
        Privilege privilege = this.privileges.getPrivilege((RestrictedPoint)LockableRestrictedPoint.INSTALLATION);
        return this.privilegeDecorator.lockWithPrivilege(action, privilege);
    }
}

