/*
 * Decompiled with CFR 0.152.
 */
package com.ur.g5.installation.action;

import com.ur.g5.MenuImageResource;
import com.ur.g5.TextResource;
import com.ur.g5.installation.action.AbstractInstallationAction;
import com.ur.polyscope.filemanager.FileContainer;
import com.ur.polyscope.filemanager.FileManagerConfiguration;
import com.ur.polyscope.filemanager.FilePersistence;
import com.ur.polyscope.installation.PersistanceMetaData;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.polyscope.viewfacade.lang.ErrorablePanel;
import com.ur.polyscope.viewfacade.safety.SafetySettingsComparator;
import com.ur.swing.ActionDefinition;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.util.event.EventManager;
import com.ur.view.installation.PerformLoadInstallation;
import com.ur.view.installation.QueryUserWhenLoading;
import com.ur.view.installation.filemanager.RobotInstallationFileManagerConfiguration;
import com.ur.view.polyscope.persistence.installation.InstallationFilePersistence;
import gui.installation.RobotInstallationLookupService;
import gui.tools.ConfirmationMessageProvider;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import java.awt.event.ActionEvent;
import javax.inject.Inject;

class LoadInstallationAction
extends AbstractInstallationAction {
    private final FilePersistence persistence;
    private final RobotInstallationSite installationSite;
    private final RobotInstallationLookupService installationLookupService;
    private final SafetySettingsComparator safetySettingsComparator;
    private final InstallationLoadingContext installationLoadingContext;
    private final ErrorablePanel errorablePanel;
    private final EventManager eventManager;
    private final com.ur.i18n.TextResource textResource;

    @Inject
    public LoadInstallationAction(FilePersistence persistence, RobotInstallationSite installationSite, RobotInstallationLookupService installationLookupService, TextResource g5TextResource, SafetySettingsComparator safetySettingsComparator, InstallationLoadingContext installationLoadingContext, DialogCreator dialogCreator, com.ur.i18n.TextResource textResource, ErrorablePanel errorablePanel, EventManager eventManager) {
        super(installationSite, dialogCreator);
        this.persistence = persistence;
        this.installationSite = installationSite;
        this.installationLookupService = installationLookupService;
        this.safetySettingsComparator = safetySettingsComparator;
        this.installationLoadingContext = installationLoadingContext;
        this.textResource = textResource;
        this.errorablePanel = errorablePanel;
        this.eventManager = eventManager;
        this.putValue("Function", ActionDefinition.Function.POPUP_MENU_ITEM);
        this.putValue("SmallIcon", MenuImageResource.installationSmall());
        this.putValue("SelectedSmallIcon", MenuImageResource.installationSmallHover());
        this.putValue("Name", g5TextResource.FileInstallation());
        this.putValue("InternalName", InstallationFilePersistence.LOAD_INSTALLATION);
    }

    public void doActionPerformed(ActionEvent e) {
        ConfirmationMessageProvider confirmationMessage = LanguagePack.getConfirmationMessages();
        ConfirmationMessage message = confirmationMessage.confirmUnsavedInstallationChangesOnLoad();
        if (this.askUserToSaveUnsavedChanges(message)) {
            PerformLoadInstallation installationFileContainer = new PerformLoadInstallation((QueryUserWhenLoading)this, this.installationSite, this.installationLookupService, this.safetySettingsComparator, this.installationLoadingContext, this.textResource, this.errorablePanel, this.eventManager);
            installationFileContainer.setFile(this.installationSite == null || this.installationSite.getInstallation() == null ? null : ((PersistanceMetaData)this.installationSite.getInstallation().getMetaData(PersistanceMetaData.class)).file());
            this.persistence.openFile((FileContainer)installationFileContainer, (FileManagerConfiguration)new RobotInstallationFileManagerConfiguration(this.textResource.loadInstallation()));
            this.setupVetosOfScreenStacks();
        }
    }
}

